package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.TrafficLaneInfo;
import com.autonavi.amapauto.protocol.model.item.TrafficLaneInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class DriveWayProtocolSdkModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(DriveWayProtocolSdkModel driveWayProtocolSdkModel) throws JSONException {
        if (driveWayProtocolSdkModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", driveWayProtocolSdkModel.getPackageName());
        jSONObject.put("clientPackageName", driveWayProtocolSdkModel.getClientPackageName());
        jSONObject.put("callbackId", driveWayProtocolSdkModel.getCallbackId());
        jSONObject.put("timeStamp", driveWayProtocolSdkModel.getTimeStamp());
        jSONObject.put("var1", driveWayProtocolSdkModel.getVar1());
        jSONObject.put("trafficLaneEnabled", driveWayProtocolSdkModel.p());
        jSONObject.put("trafficLaneSize", driveWayProtocolSdkModel.o());
        if (driveWayProtocolSdkModel.n() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<TrafficLaneInfo> it = driveWayProtocolSdkModel.n().iterator();
            while (it.hasNext()) {
                TrafficLaneInfo next = it.next();
                if (next != null) {
                    jSONArray.put(TrafficLaneInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("trafficLaneInfos", jSONArray);
        }
        return jSONObject;
    }
}
