package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class GuideInfoModel_JsonLubeParser implements Serializable {
    public static GuideInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        GuideInfoModel guideInfoModel = new GuideInfoModel();
        guideInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", guideInfoModel.getClientPackageName()));
        guideInfoModel.setPackageName(jSONObject.optString("packageName", guideInfoModel.getPackageName()));
        guideInfoModel.setCallbackId(jSONObject.optInt("callbackId", guideInfoModel.getCallbackId()));
        guideInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", guideInfoModel.getTimeStamp()));
        guideInfoModel.setVar1(jSONObject.optString("var1", guideInfoModel.getVar1()));
        guideInfoModel.setType(jSONObject.optInt("type", guideInfoModel.getType()));
        guideInfoModel.setCurRoadName(jSONObject.optString(StandardProtocolKey.EXTRA_CURROADNAME, guideInfoModel.getCurRoadName()));
        guideInfoModel.m(jSONObject.optString("nextRoadName", guideInfoModel.O()));
        guideInfoModel.setCameraDist(jSONObject.optInt("cameraDist", guideInfoModel.getCameraDist()));
        guideInfoModel.setCameraType(jSONObject.optInt("cameraType", guideInfoModel.getCameraType()));
        guideInfoModel.setCameraSpeed(jSONObject.optInt("cameraSpeed", guideInfoModel.getCameraSpeed()));
        guideInfoModel.d(jSONObject.optInt("cameraIndex", guideInfoModel.p()));
        guideInfoModel.j(jSONObject.optInt("icon", guideInfoModel.H()));
        guideInfoModel.k(jSONObject.optInt("newIcon", guideInfoModel.J()));
        guideInfoModel.x(jSONObject.optInt("routeRemainDis", guideInfoModel.d0()));
        guideInfoModel.y(jSONObject.optInt("routeRemainTime", guideInfoModel.f0()));
        guideInfoModel.B(jSONObject.optInt("segRemainDis", guideInfoModel.k0()));
        guideInfoModel.C(jSONObject.optInt("segRemainTime", guideInfoModel.m0()));
        guideInfoModel.e(jSONObject.optInt("carDirection", guideInfoModel.q()));
        guideInfoModel.a(jSONObject.optDouble("carLatitude", guideInfoModel.r()));
        guideInfoModel.b(jSONObject.optDouble("carLongitude", guideInfoModel.s()));
        guideInfoModel.setLimitedSpeed(jSONObject.optInt("limitedSpeed", guideInfoModel.getLimitedSpeed()));
        guideInfoModel.g(jSONObject.optInt("curSegNum", guideInfoModel.u()));
        guideInfoModel.f(jSONObject.optInt("curPointNum", guideInfoModel.t()));
        guideInfoModel.s(jSONObject.optInt("roundAboutNum", guideInfoModel.Y()));
        guideInfoModel.t(jSONObject.optInt("roundAllNum", guideInfoModel.Z()));
        guideInfoModel.v(jSONObject.optInt("routeAllDis", guideInfoModel.b0()));
        guideInfoModel.w(jSONObject.optInt("routeAllTime", guideInfoModel.c0()));
        guideInfoModel.h(jSONObject.optInt("curSpeed", guideInfoModel.v()));
        guideInfoModel.D(jSONObject.optInt("trafficLightNum", guideInfoModel.n0()));
        guideInfoModel.setSapaDist(jSONObject.optInt("sapaDist", guideInfoModel.getSapaDist()));
        guideInfoModel.n(jSONObject.optInt("nextSapaDist", guideInfoModel.Q()));
        guideInfoModel.setSapaType(jSONObject.optInt("sapaType", guideInfoModel.getSapaType()));
        guideInfoModel.o(jSONObject.optInt("nextSapaType", guideInfoModel.T()));
        guideInfoModel.setSapaNum(jSONObject.optInt("sapaNum", guideInfoModel.getSapaNum()));
        guideInfoModel.setSapaName(jSONObject.optString("sapaName", guideInfoModel.getSapaName()));
        guideInfoModel.o(jSONObject.optString("nextSapaName", guideInfoModel.S()));
        guideInfoModel.r(jSONObject.optInt("roadType", guideInfoModel.X()));
        guideInfoModel.i(jSONObject.optInt("currentRoadTotalDis", guideInfoModel.w()));
        guideInfoModel.q(jSONObject.optString("routeRemainDistanceAuto", guideInfoModel.e0()));
        guideInfoModel.r(jSONObject.optString("routeRemainTimeAuto", guideInfoModel.g0()));
        guideInfoModel.s(jSONObject.optString("sapaDistAuto", guideInfoModel.i0()));
        guideInfoModel.n(jSONObject.optString("nextSapaDistAuto", guideInfoModel.R()));
        guideInfoModel.t(jSONObject.optString("segRemainDisAuto", guideInfoModel.l0()));
        guideInfoModel.l(jSONObject.optString("nextNextRoadName", guideInfoModel.L()));
        guideInfoModel.l(jSONObject.optInt("nextNextTurnIcon", guideInfoModel.M()));
        guideInfoModel.p(jSONObject.optInt("nextSegRemainDis", guideInfoModel.U()));
        guideInfoModel.q(jSONObject.optInt("nextSegRemainTime", guideInfoModel.W()));
        guideInfoModel.j(jSONObject.optString("exitNameInfo", guideInfoModel.G()));
        guideInfoModel.i(jSONObject.optString("exitDirectionInfo", guideInfoModel.F()));
        guideInfoModel.A(jSONObject.optInt("segAssistantAction", guideInfoModel.j0()));
        guideInfoModel.u(jSONObject.optInt("roundaboutOutAngle", guideInfoModel.a0()));
        guideInfoModel.h(jSONObject.optString("etaText", guideInfoModel.E()));
        guideInfoModel.m(jSONObject.optInt("nextRoadProgressPrecent", guideInfoModel.P()));
        guideInfoModel.setJson(jSONObject.optString("json", guideInfoModel.getJson()));
        guideInfoModel.F(jSONObject.optInt("turnIconWeight", guideInfoModel.p0()));
        guideInfoModel.E(jSONObject.optInt("turnIconHeight", guideInfoModel.o0()));
        guideInfoModel.setCameraPenalty(jSONObject.optBoolean("cameraPenalty", guideInfoModel.getCameraPenalty()));
        guideInfoModel.b(jSONObject.optBoolean("nextRoadNOAOrNot", guideInfoModel.N()));
        guideInfoModel.a(jSONObject.optBoolean("newCamera", guideInfoModel.I()));
        guideInfoModel.setCameraID(jSONObject.optInt("cameraID", guideInfoModel.getCameraID()));
        guideInfoModel.f(jSONObject.optString("endPOIName", guideInfoModel.C()));
        guideInfoModel.c(jSONObject.optString("endPOIAddr", guideInfoModel.x()));
        guideInfoModel.g(jSONObject.optString("endPOIType", guideInfoModel.D()));
        guideInfoModel.d(jSONObject.optDouble("endPOILongitude", guideInfoModel.B()));
        guideInfoModel.c(jSONObject.optDouble("endPOILatitude", guideInfoModel.A()));
        guideInfoModel.b(jSONObject.optString("arrivePOIType", guideInfoModel.o()));
        guideInfoModel.setArrivePOILongitude(jSONObject.optDouble("arrivePOILongitude", guideInfoModel.getArrivePOILongitude()));
        guideInfoModel.setArrivePOILatitude(jSONObject.optDouble("arrivePOILatitude", guideInfoModel.getArrivePOILatitude()));
        guideInfoModel.H(jSONObject.optInt(StandardProtocolKey.ROUTEINFO_VIAPOITIME, guideInfoModel.s0()));
        guideInfoModel.G(jSONObject.optInt(StandardProtocolKey.ROUTEINFO_VIAPOIDISTANCE, guideInfoModel.r0()));
        guideInfoModel.d(jSONObject.optString("endPOICityName", guideInfoModel.y()));
        guideInfoModel.e(jSONObject.optString("endPOIDistrictName", guideInfoModel.z()));
        guideInfoModel.u(jSONObject.optString("viaPOIArrivalTime", guideInfoModel.q0()));
        guideInfoModel.a(jSONObject.optString("addIcon", guideInfoModel.n()));
        guideInfoModel.k(jSONObject.optString("nextNextAddIcon", guideInfoModel.K()));
        guideInfoModel.p(jSONObject.optString("nextSegRemainDisAuto", guideInfoModel.V()));
        guideInfoModel.z(jSONObject.optInt("routeRemainTrafficLightNum", guideInfoModel.h0()));
        return guideInfoModel;
    }
}
