package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class GuideInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(GuideInfoModel guideInfoModel) throws JSONException {
        if (guideInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", guideInfoModel.getPackageName());
        jSONObject.put("clientPackageName", guideInfoModel.getClientPackageName());
        jSONObject.put("callbackId", guideInfoModel.getCallbackId());
        jSONObject.put("timeStamp", guideInfoModel.getTimeStamp());
        jSONObject.put("var1", guideInfoModel.getVar1());
        jSONObject.put("type", guideInfoModel.getType());
        jSONObject.put(StandardProtocolKey.EXTRA_CURROADNAME, guideInfoModel.getCurRoadName());
        jSONObject.put("nextRoadName", guideInfoModel.O());
        jSONObject.put("cameraDist", guideInfoModel.getCameraDist());
        jSONObject.put("cameraType", guideInfoModel.getCameraType());
        jSONObject.put("cameraSpeed", guideInfoModel.getCameraSpeed());
        jSONObject.put("cameraIndex", guideInfoModel.p());
        jSONObject.put("icon", guideInfoModel.H());
        jSONObject.put("newIcon", guideInfoModel.J());
        jSONObject.put("routeRemainDis", guideInfoModel.d0());
        jSONObject.put("routeRemainTime", guideInfoModel.f0());
        jSONObject.put("segRemainDis", guideInfoModel.k0());
        jSONObject.put("segRemainTime", guideInfoModel.m0());
        jSONObject.put("carDirection", guideInfoModel.q());
        jSONObject.put("carLatitude", guideInfoModel.r());
        jSONObject.put("carLongitude", guideInfoModel.s());
        jSONObject.put("limitedSpeed", guideInfoModel.getLimitedSpeed());
        jSONObject.put("curSegNum", guideInfoModel.u());
        jSONObject.put("curPointNum", guideInfoModel.t());
        jSONObject.put("roundAboutNum", guideInfoModel.Y());
        jSONObject.put("roundAllNum", guideInfoModel.Z());
        jSONObject.put("routeAllDis", guideInfoModel.b0());
        jSONObject.put("routeAllTime", guideInfoModel.c0());
        jSONObject.put("curSpeed", guideInfoModel.v());
        jSONObject.put("trafficLightNum", guideInfoModel.n0());
        jSONObject.put("sapaDist", guideInfoModel.getSapaDist());
        jSONObject.put("nextSapaDist", guideInfoModel.Q());
        jSONObject.put("sapaType", guideInfoModel.getSapaType());
        jSONObject.put("nextSapaType", guideInfoModel.T());
        jSONObject.put("sapaNum", guideInfoModel.getSapaNum());
        jSONObject.put("sapaName", guideInfoModel.getSapaName());
        jSONObject.put("nextSapaName", guideInfoModel.S());
        jSONObject.put("roadType", guideInfoModel.X());
        jSONObject.put("currentRoadTotalDis", guideInfoModel.w());
        jSONObject.put("routeRemainDistanceAuto", guideInfoModel.e0());
        jSONObject.put("routeRemainTimeAuto", guideInfoModel.g0());
        jSONObject.put("sapaDistAuto", guideInfoModel.i0());
        jSONObject.put("nextSapaDistAuto", guideInfoModel.R());
        jSONObject.put("segRemainDisAuto", guideInfoModel.l0());
        jSONObject.put("nextNextRoadName", guideInfoModel.L());
        jSONObject.put("nextNextTurnIcon", guideInfoModel.M());
        jSONObject.put("nextSegRemainDis", guideInfoModel.U());
        jSONObject.put("nextSegRemainTime", guideInfoModel.W());
        jSONObject.put("exitNameInfo", guideInfoModel.G());
        jSONObject.put("exitDirectionInfo", guideInfoModel.F());
        jSONObject.put("segAssistantAction", guideInfoModel.j0());
        jSONObject.put("roundaboutOutAngle", guideInfoModel.a0());
        jSONObject.put("etaText", guideInfoModel.E());
        jSONObject.put("nextRoadProgressPrecent", guideInfoModel.P());
        jSONObject.put("json", guideInfoModel.getJson());
        jSONObject.put("turnIconWeight", guideInfoModel.p0());
        jSONObject.put("turnIconHeight", guideInfoModel.o0());
        jSONObject.put("cameraPenalty", guideInfoModel.getCameraPenalty());
        jSONObject.put("nextRoadNOAOrNot", guideInfoModel.N());
        jSONObject.put("newCamera", guideInfoModel.I());
        jSONObject.put("cameraID", guideInfoModel.getCameraID());
        jSONObject.put("endPOIName", guideInfoModel.C());
        jSONObject.put("endPOIAddr", guideInfoModel.x());
        jSONObject.put("endPOIType", guideInfoModel.D());
        jSONObject.put("endPOILongitude", guideInfoModel.B());
        jSONObject.put("endPOILatitude", guideInfoModel.A());
        jSONObject.put("arrivePOIType", guideInfoModel.o());
        jSONObject.put("arrivePOILongitude", guideInfoModel.getArrivePOILongitude());
        jSONObject.put("arrivePOILatitude", guideInfoModel.getArrivePOILatitude());
        jSONObject.put(StandardProtocolKey.ROUTEINFO_VIAPOITIME, guideInfoModel.s0());
        jSONObject.put(StandardProtocolKey.ROUTEINFO_VIAPOIDISTANCE, guideInfoModel.r0());
        jSONObject.put("endPOICityName", guideInfoModel.y());
        jSONObject.put("endPOIDistrictName", guideInfoModel.z());
        jSONObject.put("viaPOIArrivalTime", guideInfoModel.q0());
        jSONObject.put("addIcon", guideInfoModel.n());
        jSONObject.put("nextNextAddIcon", guideInfoModel.K());
        jSONObject.put("nextSegRemainDisAuto", guideInfoModel.V());
        jSONObject.put("routeRemainTrafficLightNum", guideInfoModel.h0());
        return jSONObject;
    }
}
