package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.IconRoadInfo;
import com.autonavi.amapauto.protocol.model.item.IconRoadInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ManeuverIconModel_JsonLubeParser implements Serializable {
    public static ManeuverIconModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ManeuverIconModel maneuverIconModel = new ManeuverIconModel();
        maneuverIconModel.setClientPackageName(jSONObject.optString("clientPackageName", maneuverIconModel.getClientPackageName()));
        maneuverIconModel.setPackageName(jSONObject.optString("packageName", maneuverIconModel.getPackageName()));
        maneuverIconModel.setCallbackId(jSONObject.optInt("callbackId", maneuverIconModel.getCallbackId()));
        maneuverIconModel.setTimeStamp(jSONObject.optLong("timeStamp", maneuverIconModel.getTimeStamp()));
        maneuverIconModel.setVar1(jSONObject.optString("var1", maneuverIconModel.getVar1()));
        JSONArray optJSONArray = jSONObject.optJSONArray("iconRoadInfoList");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<IconRoadInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(IconRoadInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            maneuverIconModel.a(arrayList);
        }
        maneuverIconModel.c(jSONObject.optInt("aroundNum", maneuverIconModel.n()));
        maneuverIconModel.d(jSONObject.optInt("iconId", maneuverIconModel.o()));
        return maneuverIconModel;
    }
}
