package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.IconRoadInfo;
import com.autonavi.amapauto.protocol.model.item.IconRoadInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ManeuverIconModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ManeuverIconModel maneuverIconModel) throws JSONException {
        if (maneuverIconModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", maneuverIconModel.getPackageName());
        jSONObject.put("clientPackageName", maneuverIconModel.getClientPackageName());
        jSONObject.put("callbackId", maneuverIconModel.getCallbackId());
        jSONObject.put("timeStamp", maneuverIconModel.getTimeStamp());
        jSONObject.put("var1", maneuverIconModel.getVar1());
        if (maneuverIconModel.p() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<IconRoadInfo> it = maneuverIconModel.p().iterator();
            while (it.hasNext()) {
                IconRoadInfo next = it.next();
                if (next != null) {
                    jSONArray.put(IconRoadInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("iconRoadInfoList", jSONArray);
        }
        jSONObject.put("aroundNum", maneuverIconModel.n());
        jSONObject.put("iconId", maneuverIconModel.o());
        return jSONObject;
    }
}
