package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class MyLocationInfoModel_JsonLubeParser implements Serializable {
    public static MyLocationInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        MyLocationInfoModel myLocationInfoModel = new MyLocationInfoModel();
        myLocationInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", myLocationInfoModel.getClientPackageName()));
        myLocationInfoModel.setPackageName(jSONObject.optString("packageName", myLocationInfoModel.getPackageName()));
        myLocationInfoModel.setCallbackId(jSONObject.optInt("callbackId", myLocationInfoModel.getCallbackId()));
        myLocationInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", myLocationInfoModel.getTimeStamp()));
        myLocationInfoModel.setVar1(jSONObject.optString("var1", myLocationInfoModel.getVar1()));
        myLocationInfoModel.b(jSONObject.optString("myLocationName", myLocationInfoModel.o()));
        myLocationInfoModel.setPoiName(jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, myLocationInfoModel.getPoiName()));
        myLocationInfoModel.setCityName(jSONObject.optString("cityName", myLocationInfoModel.getCityName()));
        myLocationInfoModel.setDistrictName(jSONObject.optString("districtName", myLocationInfoModel.getDistrictName()));
        myLocationInfoModel.setLongitude(jSONObject.optDouble("longitude", myLocationInfoModel.getLongitude()));
        myLocationInfoModel.setLatitude(jSONObject.optDouble("latitude", myLocationInfoModel.getLatitude()));
        myLocationInfoModel.setCountryName(jSONObject.optString("countryName", myLocationInfoModel.getCountryName()));
        myLocationInfoModel.setCountryCode(jSONObject.optString("countryCode", myLocationInfoModel.getCountryCode()));
        myLocationInfoModel.setProvinceName(jSONObject.optString("provinceName", myLocationInfoModel.getProvinceName()));
        myLocationInfoModel.c(jSONObject.optString("provinceCode", myLocationInfoModel.p()));
        myLocationInfoModel.setCityCode(jSONObject.optString("cityCode", myLocationInfoModel.getCityCode()));
        myLocationInfoModel.a(jSONObject.optString("districtCode", myLocationInfoModel.n()));
        myLocationInfoModel.setFullAddress(jSONObject.optString("fullAddress", myLocationInfoModel.getFullAddress()));
        myLocationInfoModel.setAddress(jSONObject.optString(StandardProtocolKey.POI_ADDRESS, myLocationInfoModel.getAddress()));
        return myLocationInfoModel;
    }
}
