package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class MyLocationInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(MyLocationInfoModel myLocationInfoModel) throws JSONException {
        if (myLocationInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", myLocationInfoModel.getPackageName());
        jSONObject.put("clientPackageName", myLocationInfoModel.getClientPackageName());
        jSONObject.put("callbackId", myLocationInfoModel.getCallbackId());
        jSONObject.put("timeStamp", myLocationInfoModel.getTimeStamp());
        jSONObject.put("var1", myLocationInfoModel.getVar1());
        jSONObject.put("myLocationName", myLocationInfoModel.o());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, myLocationInfoModel.getPoiName());
        jSONObject.put("cityName", myLocationInfoModel.getCityName());
        jSONObject.put("districtName", myLocationInfoModel.getDistrictName());
        jSONObject.put("longitude", myLocationInfoModel.getLongitude());
        jSONObject.put("latitude", myLocationInfoModel.getLatitude());
        jSONObject.put("countryName", myLocationInfoModel.getCountryName());
        jSONObject.put("countryCode", myLocationInfoModel.getCountryCode());
        jSONObject.put("provinceName", myLocationInfoModel.getProvinceName());
        jSONObject.put("provinceCode", myLocationInfoModel.p());
        jSONObject.put("cityCode", myLocationInfoModel.getCityCode());
        jSONObject.put("districtCode", myLocationInfoModel.n());
        jSONObject.put("fullAddress", myLocationInfoModel.getFullAddress());
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, myLocationInfoModel.getAddress());
        return jSONObject;
    }
}
