package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.ProtocolParkInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolParkInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ParkInfoModel_JsonLubeParser implements Serializable {
    public static ParkInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ParkInfoModel parkInfoModel = new ParkInfoModel();
        parkInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", parkInfoModel.getClientPackageName()));
        parkInfoModel.setPackageName(jSONObject.optString("packageName", parkInfoModel.getPackageName()));
        parkInfoModel.setCallbackId(jSONObject.optInt("callbackId", parkInfoModel.getCallbackId()));
        parkInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", parkInfoModel.getTimeStamp()));
        parkInfoModel.setVar1(jSONObject.optString("var1", parkInfoModel.getVar1()));
        parkInfoModel.c(jSONObject.optInt("dialogueType", parkInfoModel.n()));
        parkInfoModel.setCount(jSONObject.optInt("count", parkInfoModel.getCount()));
        JSONArray optJSONArray = jSONObject.optJSONArray("protocolParkInfos");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<ProtocolParkInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(ProtocolParkInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            parkInfoModel.a(arrayList);
        }
        return parkInfoModel;
    }
}
