package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.ProtocolParkInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolParkInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ParkInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ParkInfoModel parkInfoModel) throws JSONException {
        if (parkInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", parkInfoModel.getPackageName());
        jSONObject.put("clientPackageName", parkInfoModel.getClientPackageName());
        jSONObject.put("callbackId", parkInfoModel.getCallbackId());
        jSONObject.put("timeStamp", parkInfoModel.getTimeStamp());
        jSONObject.put("var1", parkInfoModel.getVar1());
        jSONObject.put("dialogueType", parkInfoModel.n());
        jSONObject.put("count", parkInfoModel.getCount());
        if (parkInfoModel.o() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<ProtocolParkInfo> it = parkInfoModel.o().iterator();
            while (it.hasNext()) {
                ProtocolParkInfo next = it.next();
                if (next != null) {
                    jSONArray.put(ProtocolParkInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("protocolParkInfos", jSONArray);
        }
        return jSONObject;
    }
}
