package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.alibaba.wireless.security.open.securitybodysdk.ISecurityBodyPageTrack;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.HotWordInfo;
import com.autonavi.wireless.WirelessSDK;
import java.util.ArrayList;

@Keep
/* loaded from: classes.dex */
public class ReqRegistVRKeywordsModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqRegistVRKeywordsModel> CREATOR = new a();
    public ArrayList<HotWordInfo> data;
    public ArrayList<String> keywords;
    public String pageId;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqRegistVRKeywordsModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqRegistVRKeywordsModel createFromParcel(Parcel parcel) {
            return new ReqRegistVRKeywordsModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqRegistVRKeywordsModel[] newArray(int i) {
            return new ReqRegistVRKeywordsModel[i];
        }
    }

    public ReqRegistVRKeywordsModel() {
        setProtocolID(80170);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public ArrayList<HotWordInfo> getData() {
        return this.data;
    }

    public ArrayList<String> getKeywords() {
        return this.keywords;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setData(ArrayList<HotWordInfo> arrayList) {
        this.data = arrayList;
    }

    public void setKeywords(ArrayList<String> arrayList) {
        this.keywords = arrayList;
    }

    public void setPageId(String str) {
        this.pageId = str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keywords");
        sb.append(": ");
        ArrayList<String> arrayList = this.keywords;
        sb.append(arrayList != null ? arrayList.toString() : "null");
        sb.append("\n");
        sb.append(ISecurityBodyPageTrack.PAGE_ID_KEY);
        sb.append(": ");
        sb.append(this.pageId);
        sb.append("\n");
        sb.append(WirelessSDK.KEY_DATA);
        sb.append(": ");
        ArrayList<HotWordInfo> arrayList2 = this.data;
        sb.append(arrayList2 != null ? arrayList2.toString() : "null");
        sb.append("\n");
        return sb.toString();
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeStringList(this.keywords);
        parcel.writeString(this.pageId);
        if (getDataVersion() >= 1) {
            parcel.writeTypedList(this.data);
        }
    }

    public ReqRegistVRKeywordsModel(Parcel parcel) {
        super(parcel);
        this.keywords = parcel.createStringArrayList();
        this.pageId = parcel.readString();
        if (getDataVersion() >= 1) {
            this.data = parcel.createTypedArrayList(HotWordInfo.CREATOR);
        }
    }
}
