package com.autonavi.amapauto.protocol.model.service;

import com.alibaba.wireless.security.open.securitybodysdk.ISecurityBodyPageTrack;
import com.autonavi.amapauto.protocol.model.item.HotWordInfo;
import com.autonavi.amapauto.protocol.model.item.HotWordInfo_JsonLubeSerializer;
import com.autonavi.wireless.WirelessSDK;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ReqRegistVRKeywordsModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ReqRegistVRKeywordsModel reqRegistVRKeywordsModel) throws JSONException {
        if (reqRegistVRKeywordsModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", reqRegistVRKeywordsModel.getPackageName());
        jSONObject.put("clientPackageName", reqRegistVRKeywordsModel.getClientPackageName());
        jSONObject.put("callbackId", reqRegistVRKeywordsModel.getCallbackId());
        jSONObject.put("timeStamp", reqRegistVRKeywordsModel.getTimeStamp());
        jSONObject.put("var1", reqRegistVRKeywordsModel.getVar1());
        if (reqRegistVRKeywordsModel.getKeywords() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<String> it = reqRegistVRKeywordsModel.getKeywords().iterator();
            while (it.hasNext()) {
                jSONArray.put(it.next());
            }
            jSONObject.put("keywords", jSONArray);
        }
        jSONObject.put(ISecurityBodyPageTrack.PAGE_ID_KEY, reqRegistVRKeywordsModel.getPageId());
        if (reqRegistVRKeywordsModel.getData() != null) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator<HotWordInfo> it2 = reqRegistVRKeywordsModel.getData().iterator();
            while (it2.hasNext()) {
                HotWordInfo next = it2.next();
                if (next != null) {
                    jSONArray2.put(HotWordInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put(WirelessSDK.KEY_DATA, jSONArray2);
        }
        return jSONObject;
    }
}
