package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class ReqSend2carInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<ReqSend2carInfoModel> CREATOR = new a();
    public String address;
    public int distance;

    @o60(isLonLat = true)
    public double dlat;

    @o60(isLonLat = true)
    public double dlon;
    public String phone;
    public String poiName;
    public String poiid;
    public String poitype;
    public String send2carData;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<ReqSend2carInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqSend2carInfoModel createFromParcel(Parcel parcel) {
            return new ReqSend2carInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public ReqSend2carInfoModel[] newArray(int i) {
            return new ReqSend2carInfoModel[i];
        }
    }

    public ReqSend2carInfoModel() {
        setProtocolID(80089);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getDlat() {
        return this.dlat;
    }

    public double getDlon() {
        return this.dlon;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 2;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public String getPoiid() {
        return this.poiid;
    }

    public String getPoitype() {
        return this.poitype;
    }

    public String getSend2carData() {
        return this.send2carData;
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public void setDistance(int i) {
        this.distance = i;
    }

    public void setDlat(double d) {
        this.dlat = d;
    }

    public void setDlon(double d) {
        this.dlon = d;
    }

    public void setPhone(String str) {
        this.phone = str;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public void setPoiid(String str) {
        this.poiid = str;
    }

    public void setPoitype(String str) {
        this.poitype = str;
    }

    public void setSend2carData(String str) {
        this.send2carData = str;
    }

    public String toString() {
        return "dlat: " + this.dlat + "\ndlon: " + this.dlon + "\n" + StandardProtocolKey.POITYPE + ": " + this.poitype + "\nsend2carData: " + this.send2carData + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeDouble(this.dlat);
        parcel.writeDouble(this.dlon);
        parcel.writeString(this.poitype);
        parcel.writeString(this.send2carData);
        if (getDataVersion() >= 1) {
            parcel.writeString(this.poiid);
        }
        if (getDataVersion() >= 2) {
            parcel.writeString(this.address);
            parcel.writeString(this.phone);
            parcel.writeInt(this.distance);
            parcel.writeString(this.poiName);
        }
    }

    public ReqSend2carInfoModel(double d, double d2, String str, String str2) {
        setProtocolID(80089);
        this.dlat = d;
        this.dlon = d2;
        this.poitype = str;
        this.send2carData = str2;
    }

    public ReqSend2carInfoModel(Parcel parcel) {
        super(parcel);
        this.dlat = parcel.readDouble();
        this.dlon = parcel.readDouble();
        this.poitype = parcel.readString();
        this.send2carData = parcel.readString();
        if (getDataVersion() >= 1) {
            this.poiid = parcel.readString();
        }
        if (getDataVersion() >= 2) {
            this.address = parcel.readString();
            this.phone = parcel.readString();
            this.distance = parcel.readInt();
            this.poiName = parcel.readString();
        }
    }
}
