package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ReqSend2carInfoModel_JsonLubeParser implements Serializable {
    public static ReqSend2carInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ReqSend2carInfoModel reqSend2carInfoModel = new ReqSend2carInfoModel();
        reqSend2carInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", reqSend2carInfoModel.getClientPackageName()));
        reqSend2carInfoModel.setPackageName(jSONObject.optString("packageName", reqSend2carInfoModel.getPackageName()));
        reqSend2carInfoModel.setCallbackId(jSONObject.optInt("callbackId", reqSend2carInfoModel.getCallbackId()));
        reqSend2carInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", reqSend2carInfoModel.getTimeStamp()));
        reqSend2carInfoModel.setVar1(jSONObject.optString("var1", reqSend2carInfoModel.getVar1()));
        reqSend2carInfoModel.setPoiid(jSONObject.optString(StandardProtocolKey.POIID, reqSend2carInfoModel.getPoiid()));
        reqSend2carInfoModel.setDlat(jSONObject.optDouble("dlat", reqSend2carInfoModel.getDlat()));
        reqSend2carInfoModel.setDlon(jSONObject.optDouble("dlon", reqSend2carInfoModel.getDlon()));
        reqSend2carInfoModel.setPoitype(jSONObject.optString(StandardProtocolKey.POITYPE, reqSend2carInfoModel.getPoitype()));
        reqSend2carInfoModel.setSend2carData(jSONObject.optString("send2carData", reqSend2carInfoModel.getSend2carData()));
        reqSend2carInfoModel.setAddress(jSONObject.optString(StandardProtocolKey.POI_ADDRESS, reqSend2carInfoModel.getAddress()));
        reqSend2carInfoModel.setPhone(jSONObject.optString(StandardProtocolKey.PHONE, reqSend2carInfoModel.getPhone()));
        reqSend2carInfoModel.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, reqSend2carInfoModel.getDistance()));
        reqSend2carInfoModel.setPoiName(jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, reqSend2carInfoModel.getPoiName()));
        return reqSend2carInfoModel;
    }
}
