package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ReqSend2carInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ReqSend2carInfoModel reqSend2carInfoModel) throws JSONException {
        if (reqSend2carInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", reqSend2carInfoModel.getPackageName());
        jSONObject.put("clientPackageName", reqSend2carInfoModel.getClientPackageName());
        jSONObject.put("callbackId", reqSend2carInfoModel.getCallbackId());
        jSONObject.put("timeStamp", reqSend2carInfoModel.getTimeStamp());
        jSONObject.put("var1", reqSend2carInfoModel.getVar1());
        jSONObject.put(StandardProtocolKey.POIID, reqSend2carInfoModel.getPoiid());
        jSONObject.put("dlat", reqSend2carInfoModel.getDlat());
        jSONObject.put("dlon", reqSend2carInfoModel.getDlon());
        jSONObject.put(StandardProtocolKey.POITYPE, reqSend2carInfoModel.getPoitype());
        jSONObject.put("send2carData", reqSend2carInfoModel.getSend2carData());
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, reqSend2carInfoModel.getAddress());
        jSONObject.put(StandardProtocolKey.PHONE, reqSend2carInfoModel.getPhone());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, reqSend2carInfoModel.getDistance());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, reqSend2carInfoModel.getPoiName());
        return jSONObject;
    }
}
