package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RequestRouteResultModel_JsonLubeParser implements Serializable {
    public static RequestRouteResultModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RequestRouteResultModel requestRouteResultModel = new RequestRouteResultModel();
        requestRouteResultModel.setClientPackageName(jSONObject.optString("clientPackageName", requestRouteResultModel.getClientPackageName()));
        requestRouteResultModel.setPackageName(jSONObject.optString("packageName", requestRouteResultModel.getPackageName()));
        requestRouteResultModel.setCallbackId(jSONObject.optInt("callbackId", requestRouteResultModel.getCallbackId()));
        requestRouteResultModel.setTimeStamp(jSONObject.optLong("timeStamp", requestRouteResultModel.getTimeStamp()));
        requestRouteResultModel.setVar1(jSONObject.optString("var1", requestRouteResultModel.getVar1()));
        requestRouteResultModel.setCount(jSONObject.optInt("count", requestRouteResultModel.getCount()));
        requestRouteResultModel.setJson(jSONObject.optString("json", requestRouteResultModel.getJson()));
        JSONArray optJSONArray = jSONObject.optJSONArray("protocolRouteInfos");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<ProtocolRouteInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(ProtocolRouteInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            requestRouteResultModel.a(arrayList);
        }
        requestRouteResultModel.b(jSONObject.optString("fromPoiName", requestRouteResultModel.q()));
        requestRouteResultModel.a(jSONObject.optString("fromPoiAddr", requestRouteResultModel.n()));
        requestRouteResultModel.b(jSONObject.optDouble("fromPoiLongitude", requestRouteResultModel.p()));
        requestRouteResultModel.a(jSONObject.optDouble("fromPoiLatitude", requestRouteResultModel.o()));
        requestRouteResultModel.c(jSONObject.optInt(StandardProtocolKey.MID_POIS_NUM, requestRouteResultModel.s()));
        requestRouteResultModel.c(jSONObject.optString(StandardProtocolKey.MID_POI_ARRAY, requestRouteResultModel.r()));
        requestRouteResultModel.e(jSONObject.optString("toPoiName", requestRouteResultModel.x()));
        requestRouteResultModel.d(jSONObject.optString("toPoiAddr", requestRouteResultModel.u()));
        requestRouteResultModel.d(jSONObject.optDouble("toPoiLongitude", requestRouteResultModel.w()));
        requestRouteResultModel.c(jSONObject.optDouble("toPoiLatitude", requestRouteResultModel.v()));
        return requestRouteResultModel;
    }
}
