package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RequestRouteResultModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RequestRouteResultModel requestRouteResultModel) throws JSONException {
        if (requestRouteResultModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", requestRouteResultModel.getPackageName());
        jSONObject.put("clientPackageName", requestRouteResultModel.getClientPackageName());
        jSONObject.put("callbackId", requestRouteResultModel.getCallbackId());
        jSONObject.put("timeStamp", requestRouteResultModel.getTimeStamp());
        jSONObject.put("var1", requestRouteResultModel.getVar1());
        jSONObject.put("count", requestRouteResultModel.getCount());
        jSONObject.put("json", requestRouteResultModel.getJson());
        if (requestRouteResultModel.t() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<ProtocolRouteInfo> it = requestRouteResultModel.t().iterator();
            while (it.hasNext()) {
                ProtocolRouteInfo next = it.next();
                if (next != null) {
                    jSONArray.put(ProtocolRouteInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("protocolRouteInfos", jSONArray);
        }
        jSONObject.put("fromPoiName", requestRouteResultModel.q());
        jSONObject.put("fromPoiAddr", requestRouteResultModel.n());
        jSONObject.put("fromPoiLongitude", requestRouteResultModel.p());
        jSONObject.put("fromPoiLatitude", requestRouteResultModel.o());
        jSONObject.put(StandardProtocolKey.MID_POIS_NUM, requestRouteResultModel.s());
        jSONObject.put(StandardProtocolKey.MID_POI_ARRAY, requestRouteResultModel.r());
        jSONObject.put("toPoiName", requestRouteResultModel.x());
        jSONObject.put("toPoiAddr", requestRouteResultModel.u());
        jSONObject.put("toPoiLongitude", requestRouteResultModel.w());
        jSONObject.put("toPoiLatitude", requestRouteResultModel.v());
        return jSONObject;
    }
}
