package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo_JsonLubeParser;
import com.autonavi.amapauto.protocol.model.item.ProtocolViaPOIInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolViaPOIInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RouteInfoModel_JsonLubeParser implements Serializable {
    public static RouteInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RouteInfoModel routeInfoModel = new RouteInfoModel();
        routeInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", routeInfoModel.getClientPackageName()));
        routeInfoModel.setPackageName(jSONObject.optString("packageName", routeInfoModel.getPackageName()));
        routeInfoModel.setCallbackId(jSONObject.optInt("callbackId", routeInfoModel.getCallbackId()));
        routeInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", routeInfoModel.getTimeStamp()));
        routeInfoModel.setVar1(jSONObject.optString("var1", routeInfoModel.getVar1()));
        routeInfoModel.setCount(jSONObject.optInt("count", routeInfoModel.getCount()));
        routeInfoModel.h(jSONObject.optString("startPOIName", routeInfoModel.C()));
        routeInfoModel.g(jSONObject.optString("startPOIAddr", routeInfoModel.z()));
        routeInfoModel.d(jSONObject.optDouble("startPOILongitude", routeInfoModel.B()));
        routeInfoModel.c(jSONObject.optDouble("startPOILatitude", routeInfoModel.A()));
        routeInfoModel.d(jSONObject.optString("endPOIName", routeInfoModel.t()));
        routeInfoModel.c(jSONObject.optString("endPOIAddr", routeInfoModel.q()));
        routeInfoModel.b(jSONObject.optDouble("endPOILongitude", routeInfoModel.s()));
        routeInfoModel.a(jSONObject.optDouble("endPOILatitude", routeInfoModel.r()));
        routeInfoModel.setArrivePOILongitude(jSONObject.optDouble("arrivePOILongitude", routeInfoModel.getArrivePOILongitude()));
        routeInfoModel.setArrivePOILatitude(jSONObject.optDouble("arrivePOILatitude", routeInfoModel.getArrivePOILatitude()));
        routeInfoModel.i(jSONObject.optString("startPOIType", routeInfoModel.D()));
        routeInfoModel.e(jSONObject.optString("endPOIType", routeInfoModel.u()));
        routeInfoModel.b(jSONObject.optString("arrivePOIType", routeInfoModel.p()));
        routeInfoModel.e(jSONObject.optInt("viaNumbers", routeInfoModel.E()));
        routeInfoModel.d(jSONObject.optInt("routePreference", routeInfoModel.y()));
        JSONArray optJSONArray = jSONObject.optJSONArray("protocolViaPOIInfos");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<ProtocolViaPOIInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(ProtocolViaPOIInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            routeInfoModel.b(arrayList);
        }
        JSONArray optJSONArray2 = jSONObject.optJSONArray("protocolRouteInfos");
        if (optJSONArray2 != null) {
            int length2 = optJSONArray2.length();
            ArrayList<ProtocolRouteInfo> arrayList2 = new ArrayList<>(length2);
            for (int i2 = 0; i2 < length2; i2++) {
                arrayList2.add(ProtocolRouteInfo_JsonLubeParser.parse(optJSONArray2.optJSONObject(i2)));
            }
            routeInfoModel.a(arrayList2);
        }
        routeInfoModel.setJson(jSONObject.optString("json", routeInfoModel.getJson()));
        routeInfoModel.setNewStrategy(jSONObject.optInt("newStrategy", routeInfoModel.getNewStrategy()));
        routeInfoModel.f(jSONObject.optString(StandardProtocolKey.TO_ENDPOIID, routeInfoModel.v()));
        routeInfoModel.c(jSONObject.optInt("arrivePOIDistance", routeInfoModel.n()));
        routeInfoModel.a(jSONObject.optString("arrivePOIPhone", routeInfoModel.o()));
        routeInfoModel.f(jSONObject.optInt("viaPOITotal", routeInfoModel.F()));
        return routeInfoModel;
    }
}
