package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo_JsonLubeSerializer;
import com.autonavi.amapauto.protocol.model.item.ProtocolViaPOIInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolViaPOIInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RouteInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RouteInfoModel routeInfoModel) throws JSONException {
        if (routeInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", routeInfoModel.getPackageName());
        jSONObject.put("clientPackageName", routeInfoModel.getClientPackageName());
        jSONObject.put("callbackId", routeInfoModel.getCallbackId());
        jSONObject.put("timeStamp", routeInfoModel.getTimeStamp());
        jSONObject.put("var1", routeInfoModel.getVar1());
        jSONObject.put("count", routeInfoModel.getCount());
        jSONObject.put("startPOIName", routeInfoModel.C());
        jSONObject.put("startPOIAddr", routeInfoModel.z());
        jSONObject.put("startPOILongitude", routeInfoModel.B());
        jSONObject.put("startPOILatitude", routeInfoModel.A());
        jSONObject.put("endPOIName", routeInfoModel.t());
        jSONObject.put("endPOIAddr", routeInfoModel.q());
        jSONObject.put("endPOILongitude", routeInfoModel.s());
        jSONObject.put("endPOILatitude", routeInfoModel.r());
        jSONObject.put("arrivePOILongitude", routeInfoModel.getArrivePOILongitude());
        jSONObject.put("arrivePOILatitude", routeInfoModel.getArrivePOILatitude());
        jSONObject.put("startPOIType", routeInfoModel.D());
        jSONObject.put("endPOIType", routeInfoModel.u());
        jSONObject.put("arrivePOIType", routeInfoModel.p());
        jSONObject.put("viaNumbers", routeInfoModel.E());
        jSONObject.put("routePreference", routeInfoModel.y());
        if (routeInfoModel.x() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<ProtocolViaPOIInfo> it = routeInfoModel.x().iterator();
            while (it.hasNext()) {
                ProtocolViaPOIInfo next = it.next();
                if (next != null) {
                    jSONArray.put(ProtocolViaPOIInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("protocolViaPOIInfos", jSONArray);
        }
        if (routeInfoModel.w() != null) {
            JSONArray jSONArray2 = new JSONArray();
            Iterator<ProtocolRouteInfo> it2 = routeInfoModel.w().iterator();
            while (it2.hasNext()) {
                ProtocolRouteInfo next2 = it2.next();
                if (next2 != null) {
                    jSONArray2.put(ProtocolRouteInfo_JsonLubeSerializer.serialize(next2));
                }
            }
            jSONObject.put("protocolRouteInfos", jSONArray2);
        }
        jSONObject.put("json", routeInfoModel.getJson());
        jSONObject.put("newStrategy", routeInfoModel.getNewStrategy());
        jSONObject.put(StandardProtocolKey.TO_ENDPOIID, routeInfoModel.v());
        jSONObject.put("arrivePOIDistance", routeInfoModel.n());
        jSONObject.put("arrivePOIPhone", routeInfoModel.o());
        jSONObject.put("viaPOITotal", routeInfoModel.F());
        return jSONObject;
    }
}
