package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RouteTMCSegment_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RouteTMCSegment routeTMCSegment) throws JSONException {
        if (routeTMCSegment == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", routeTMCSegment.getPackageName());
        jSONObject.put("clientPackageName", routeTMCSegment.getClientPackageName());
        jSONObject.put("callbackId", routeTMCSegment.getCallbackId());
        jSONObject.put("timeStamp", routeTMCSegment.getTimeStamp());
        jSONObject.put("var1", routeTMCSegment.getVar1());
        jSONObject.put("status", routeTMCSegment.o());
        jSONObject.put(StandardProtocolKey.EXTRA_NUM, routeTMCSegment.getNum());
        jSONObject.put("percent", routeTMCSegment.n());
        jSONObject.put("trafficDistance", routeTMCSegment.p());
        jSONObject.put("trafficTime", routeTMCSegment.q());
        return jSONObject;
    }
}
