package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspCameraSpeedInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspCameraSpeedInfoModel> CREATOR = new a();
    public int averageSpeed;
    public int cameraType;
    public double dlat;
    public double dlon;
    public double endDistance;
    public String endDistanceText;
    public double intervalDistance;
    public String intervalDistanceText;
    public int limitedSpeed;
    public double slat;
    public double slon;
    public double startDistance;
    public String startDistanceText;
    public int state;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspCameraSpeedInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspCameraSpeedInfoModel createFromParcel(Parcel parcel) {
            return new RspCameraSpeedInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspCameraSpeedInfoModel[] newArray(int i) {
            return new RspCameraSpeedInfoModel[i];
        }
    }

    public RspCameraSpeedInfoModel() {
        setProtocolID(80105);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getAverageSpeed() {
        return this.averageSpeed;
    }

    public int getCameraType() {
        return this.cameraType;
    }

    public double getDlat() {
        return this.dlat;
    }

    public double getDlon() {
        return this.dlon;
    }

    public double getEndDistance() {
        return this.endDistance;
    }

    public String getEndDistanceText() {
        return this.endDistanceText;
    }

    public double getIntervalDistance() {
        return this.intervalDistance;
    }

    public String getIntervalDistanceText() {
        return this.intervalDistanceText;
    }

    public int getLimitedSpeed() {
        return this.limitedSpeed;
    }

    public double getSlat() {
        return this.slat;
    }

    public double getSlon() {
        return this.slon;
    }

    public double getStartDistance() {
        return this.startDistance;
    }

    public String getStartDistanceText() {
        return this.startDistanceText;
    }

    public int getState() {
        return this.state;
    }

    public void setAverageSpeed(int i) {
        this.averageSpeed = i;
    }

    public void setCameraType(int i) {
        this.cameraType = i;
    }

    public void setDlat(double d) {
        this.dlat = d;
    }

    public void setDlon(double d) {
        this.dlon = d;
    }

    public void setEndDistance(double d) {
        this.endDistance = d;
    }

    public void setEndDistanceText(String str) {
        this.endDistanceText = str;
    }

    public void setIntervalDistance(double d) {
        this.intervalDistance = d;
    }

    public void setIntervalDistanceText(String str) {
        this.intervalDistanceText = str;
    }

    public void setLimitedSpeed(int i) {
        this.limitedSpeed = i;
    }

    public void setSlat(double d) {
        this.slat = d;
    }

    public void setSlon(double d) {
        this.slon = d;
    }

    public void setStartDistance(double d) {
        this.startDistance = d;
    }

    public void setStartDistanceText(String str) {
        this.startDistanceText = str;
    }

    public void setState(int i) {
        this.state = i;
    }

    public String toString() {
        return "startDistanceText: " + this.startDistanceText + "\n" + StandardProtocolKey.EXTRA_FUNCCONFIG_STATE + ": " + this.state + "\nslat: " + this.slat + "\ndlat: " + this.dlat + "\nslon: " + this.slon + "\naverageSpeed: " + this.averageSpeed + "\nstartDistance: " + this.startDistance + "\nendDistance: " + this.endDistance + "\nlimitedSpeed: " + this.limitedSpeed + "\nendDistanceText: " + this.endDistanceText + "\nintervalDistanceText: " + this.intervalDistanceText + "\ncameraType: " + this.cameraType + "\ndlon: " + this.dlon + "\nintervalDistance: " + this.intervalDistance + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.startDistanceText);
        parcel.writeInt(this.state);
        parcel.writeDouble(this.slat);
        parcel.writeDouble(this.dlat);
        parcel.writeDouble(this.slon);
        parcel.writeInt(this.averageSpeed);
        parcel.writeDouble(this.startDistance);
        parcel.writeDouble(this.endDistance);
        parcel.writeInt(this.limitedSpeed);
        parcel.writeString(this.endDistanceText);
        parcel.writeString(this.intervalDistanceText);
        parcel.writeInt(this.cameraType);
        parcel.writeDouble(this.dlon);
        parcel.writeDouble(this.intervalDistance);
    }

    public RspCameraSpeedInfoModel(String str, int i, double d, double d2, double d3, int i2, double d4, double d5, int i3, String str2, String str3, int i4, double d6, double d7) {
        this.startDistanceText = str;
        this.state = i;
        this.slat = d;
        this.dlat = d2;
        this.slon = d3;
        this.averageSpeed = i2;
        this.startDistance = d4;
        this.endDistance = d5;
        this.limitedSpeed = i3;
        this.endDistanceText = str2;
        this.intervalDistanceText = str3;
        this.cameraType = i4;
        this.dlon = d6;
        this.intervalDistance = d7;
        setProtocolID(80105);
    }

    public RspCameraSpeedInfoModel(Parcel parcel) {
        super(parcel);
        this.startDistanceText = parcel.readString();
        this.state = parcel.readInt();
        this.slat = parcel.readDouble();
        this.dlat = parcel.readDouble();
        this.slon = parcel.readDouble();
        this.averageSpeed = parcel.readInt();
        this.startDistance = parcel.readDouble();
        this.endDistance = parcel.readDouble();
        this.limitedSpeed = parcel.readInt();
        this.endDistanceText = parcel.readString();
        this.intervalDistanceText = parcel.readString();
        this.cameraType = parcel.readInt();
        this.dlon = parcel.readDouble();
        this.intervalDistance = parcel.readDouble();
    }
}
