package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspCameraSpeedInfoModel_JsonLubeParser implements Serializable {
    public static RspCameraSpeedInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspCameraSpeedInfoModel rspCameraSpeedInfoModel = new RspCameraSpeedInfoModel();
        rspCameraSpeedInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", rspCameraSpeedInfoModel.getClientPackageName()));
        rspCameraSpeedInfoModel.setPackageName(jSONObject.optString("packageName", rspCameraSpeedInfoModel.getPackageName()));
        rspCameraSpeedInfoModel.setCallbackId(jSONObject.optInt("callbackId", rspCameraSpeedInfoModel.getCallbackId()));
        rspCameraSpeedInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", rspCameraSpeedInfoModel.getTimeStamp()));
        rspCameraSpeedInfoModel.setVar1(jSONObject.optString("var1", rspCameraSpeedInfoModel.getVar1()));
        rspCameraSpeedInfoModel.setStartDistanceText(jSONObject.optString("startDistanceText", rspCameraSpeedInfoModel.getStartDistanceText()));
        rspCameraSpeedInfoModel.setState(jSONObject.optInt(StandardProtocolKey.EXTRA_FUNCCONFIG_STATE, rspCameraSpeedInfoModel.getState()));
        rspCameraSpeedInfoModel.setSlat(jSONObject.optDouble("slat", rspCameraSpeedInfoModel.getSlat()));
        rspCameraSpeedInfoModel.setDlat(jSONObject.optDouble("dlat", rspCameraSpeedInfoModel.getDlat()));
        rspCameraSpeedInfoModel.setSlon(jSONObject.optDouble("slon", rspCameraSpeedInfoModel.getSlon()));
        rspCameraSpeedInfoModel.setAverageSpeed(jSONObject.optInt("averageSpeed", rspCameraSpeedInfoModel.getAverageSpeed()));
        rspCameraSpeedInfoModel.setStartDistance(jSONObject.optDouble("startDistance", rspCameraSpeedInfoModel.getStartDistance()));
        rspCameraSpeedInfoModel.setEndDistance(jSONObject.optDouble("endDistance", rspCameraSpeedInfoModel.getEndDistance()));
        rspCameraSpeedInfoModel.setLimitedSpeed(jSONObject.optInt("limitedSpeed", rspCameraSpeedInfoModel.getLimitedSpeed()));
        rspCameraSpeedInfoModel.setEndDistanceText(jSONObject.optString("endDistanceText", rspCameraSpeedInfoModel.getEndDistanceText()));
        rspCameraSpeedInfoModel.setIntervalDistanceText(jSONObject.optString("intervalDistanceText", rspCameraSpeedInfoModel.getIntervalDistanceText()));
        rspCameraSpeedInfoModel.setCameraType(jSONObject.optInt("cameraType", rspCameraSpeedInfoModel.getCameraType()));
        rspCameraSpeedInfoModel.setDlon(jSONObject.optDouble("dlon", rspCameraSpeedInfoModel.getDlon()));
        rspCameraSpeedInfoModel.setIntervalDistance(jSONObject.optDouble("intervalDistance", rspCameraSpeedInfoModel.getIntervalDistance()));
        return rspCameraSpeedInfoModel;
    }
}
