package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspCameraSpeedInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspCameraSpeedInfoModel rspCameraSpeedInfoModel) throws JSONException {
        if (rspCameraSpeedInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspCameraSpeedInfoModel.getPackageName());
        jSONObject.put("clientPackageName", rspCameraSpeedInfoModel.getClientPackageName());
        jSONObject.put("callbackId", rspCameraSpeedInfoModel.getCallbackId());
        jSONObject.put("timeStamp", rspCameraSpeedInfoModel.getTimeStamp());
        jSONObject.put("var1", rspCameraSpeedInfoModel.getVar1());
        jSONObject.put("startDistanceText", rspCameraSpeedInfoModel.getStartDistanceText());
        jSONObject.put(StandardProtocolKey.EXTRA_FUNCCONFIG_STATE, rspCameraSpeedInfoModel.getState());
        jSONObject.put("slat", rspCameraSpeedInfoModel.getSlat());
        jSONObject.put("dlat", rspCameraSpeedInfoModel.getDlat());
        jSONObject.put("slon", rspCameraSpeedInfoModel.getSlon());
        jSONObject.put("averageSpeed", rspCameraSpeedInfoModel.getAverageSpeed());
        jSONObject.put("startDistance", rspCameraSpeedInfoModel.getStartDistance());
        jSONObject.put("endDistance", rspCameraSpeedInfoModel.getEndDistance());
        jSONObject.put("limitedSpeed", rspCameraSpeedInfoModel.getLimitedSpeed());
        jSONObject.put("endDistanceText", rspCameraSpeedInfoModel.getEndDistanceText());
        jSONObject.put("intervalDistanceText", rspCameraSpeedInfoModel.getIntervalDistanceText());
        jSONObject.put("cameraType", rspCameraSpeedInfoModel.getCameraType());
        jSONObject.put("dlon", rspCameraSpeedInfoModel.getDlon());
        jSONObject.put("intervalDistance", rspCameraSpeedInfoModel.getIntervalDistance());
        return jSONObject;
    }
}
