package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspGeoDecodeModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspGeoDecodeModel> CREATOR = new a();
    public String geoAddress;
    public String geoCitycode;
    public String geoCityname;
    public String geoCountrycode;
    public String geoCountryname;
    public String geoDistrictcode;
    public String geoDistrictname;
    public String geoProvincecode;
    public String geoProvincename;
    public String geofullAddress;
    public double poiLatitude;
    public double poiLongitude;
    public String poiName;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspGeoDecodeModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGeoDecodeModel createFromParcel(Parcel parcel) {
            return new RspGeoDecodeModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGeoDecodeModel[] newArray(int i) {
            return new RspGeoDecodeModel[i];
        }
    }

    public RspGeoDecodeModel() {
        this.geoCountrycode = "86";
        this.geoCountryname = "中国";
        setProtocolID(80160);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getGeoAddress() {
        return this.geoAddress;
    }

    public String getGeoCitycode() {
        return this.geoCitycode;
    }

    public String getGeoCityname() {
        return this.geoCityname;
    }

    public String getGeoCountrycode() {
        return this.geoCountrycode;
    }

    public String getGeoCountryname() {
        return this.geoCountryname;
    }

    public String getGeoDistrictcode() {
        return this.geoDistrictcode;
    }

    public String getGeoDistrictname() {
        return this.geoDistrictname;
    }

    public String getGeoProvincecode() {
        return this.geoProvincecode;
    }

    public String getGeoProvincename() {
        return this.geoProvincename;
    }

    public String getGeofullAddress() {
        return this.geofullAddress;
    }

    public double getPoiLatitude() {
        return this.poiLatitude;
    }

    public double getPoiLongitude() {
        return this.poiLongitude;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public void setGeoAddress(String str) {
        this.geoAddress = str;
    }

    public void setGeoCitycode(String str) {
        this.geoCitycode = str;
    }

    public void setGeoCityname(String str) {
        this.geoCityname = str;
    }

    public void setGeoCountrycode(String str) {
        this.geoCountrycode = str;
    }

    public void setGeoCountryname(String str) {
        this.geoCountryname = str;
    }

    public void setGeoDistrictcode(String str) {
        this.geoDistrictcode = str;
    }

    public void setGeoDistrictname(String str) {
        this.geoDistrictname = str;
    }

    public void setGeoProvincecode(String str) {
        this.geoProvincecode = str;
    }

    public void setGeoProvincename(String str) {
        this.geoProvincename = str;
    }

    public void setGeofullAddress(String str) {
        this.geofullAddress = str;
    }

    public void setPoiLatitude(double d) {
        this.poiLatitude = d;
    }

    public void setPoiLongitude(double d) {
        this.poiLongitude = d;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public String toString() {
        return "geoAddress: " + this.geoAddress + "\ngeoCitycode: " + this.geoCitycode + "\ngeoCityname: " + this.geoCityname + "\ngeoCountrycode: " + this.geoCountrycode + "\ngeoCountryname: " + this.geoCountryname + "\ngeoDistrictcode: " + this.geoDistrictcode + "\ngeoDistrictname: " + this.geoDistrictname + "\ngeofullAddress: " + this.geofullAddress + "\ngeoProvincecode: " + this.geoProvincecode + "\ngeoProvincename: " + this.geoProvincename + "\npoiLatitude: " + this.poiLatitude + "\npoiLongitude: " + this.poiLongitude + "\n" + StandardProtocolKey.EXTRA_POINAME + ": " + this.poiName + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.geoAddress);
        parcel.writeString(this.geoCitycode);
        parcel.writeString(this.geoCityname);
        parcel.writeString(this.geoCountrycode);
        parcel.writeString(this.geoCountryname);
        parcel.writeString(this.geoDistrictcode);
        parcel.writeString(this.geoDistrictname);
        parcel.writeString(this.geofullAddress);
        parcel.writeString(this.geoProvincecode);
        parcel.writeString(this.geoProvincename);
        parcel.writeDouble(this.poiLatitude);
        parcel.writeDouble(this.poiLongitude);
        parcel.writeString(this.poiName);
    }

    public RspGeoDecodeModel(Parcel parcel) {
        super(parcel);
        this.geoCountrycode = "86";
        this.geoCountryname = "中国";
        this.geoAddress = parcel.readString();
        this.geoCitycode = parcel.readString();
        this.geoCityname = parcel.readString();
        this.geoCountrycode = parcel.readString();
        this.geoCountryname = parcel.readString();
        this.geoDistrictcode = parcel.readString();
        this.geoDistrictname = parcel.readString();
        this.geofullAddress = parcel.readString();
        this.geoProvincecode = parcel.readString();
        this.geoProvincename = parcel.readString();
        this.poiLatitude = parcel.readDouble();
        this.poiLongitude = parcel.readDouble();
        this.poiName = parcel.readString();
    }
}
