package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspGeoDecodeModel_JsonLubeParser implements Serializable {
    public static RspGeoDecodeModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspGeoDecodeModel rspGeoDecodeModel = new RspGeoDecodeModel();
        rspGeoDecodeModel.setClientPackageName(jSONObject.optString("clientPackageName", rspGeoDecodeModel.getClientPackageName()));
        rspGeoDecodeModel.setPackageName(jSONObject.optString("packageName", rspGeoDecodeModel.getPackageName()));
        rspGeoDecodeModel.setCallbackId(jSONObject.optInt("callbackId", rspGeoDecodeModel.getCallbackId()));
        rspGeoDecodeModel.setTimeStamp(jSONObject.optLong("timeStamp", rspGeoDecodeModel.getTimeStamp()));
        rspGeoDecodeModel.setVar1(jSONObject.optString("var1", rspGeoDecodeModel.getVar1()));
        rspGeoDecodeModel.setGeoAddress(jSONObject.optString("geoAddress", rspGeoDecodeModel.getGeoAddress()));
        rspGeoDecodeModel.setGeoCitycode(jSONObject.optString("geoCitycode", rspGeoDecodeModel.getGeoCitycode()));
        rspGeoDecodeModel.setGeoCityname(jSONObject.optString("geoCityname", rspGeoDecodeModel.getGeoCityname()));
        rspGeoDecodeModel.setGeoCountrycode(jSONObject.optString("geoCountrycode", rspGeoDecodeModel.getGeoCountrycode()));
        rspGeoDecodeModel.setGeoCountryname(jSONObject.optString("geoCountryname", rspGeoDecodeModel.getGeoCountryname()));
        rspGeoDecodeModel.setGeoDistrictcode(jSONObject.optString("geoDistrictcode", rspGeoDecodeModel.getGeoDistrictcode()));
        rspGeoDecodeModel.setGeoDistrictname(jSONObject.optString("geoDistrictname", rspGeoDecodeModel.getGeoDistrictname()));
        rspGeoDecodeModel.setGeofullAddress(jSONObject.optString("geofullAddress", rspGeoDecodeModel.getGeofullAddress()));
        rspGeoDecodeModel.setGeoProvincecode(jSONObject.optString("geoProvincecode", rspGeoDecodeModel.getGeoProvincecode()));
        rspGeoDecodeModel.setGeoProvincename(jSONObject.optString("geoProvincename", rspGeoDecodeModel.getGeoProvincename()));
        rspGeoDecodeModel.setPoiLatitude(jSONObject.optDouble("poiLatitude", rspGeoDecodeModel.getPoiLatitude()));
        rspGeoDecodeModel.setPoiLongitude(jSONObject.optDouble("poiLongitude", rspGeoDecodeModel.getPoiLongitude()));
        rspGeoDecodeModel.setPoiName(jSONObject.optString(StandardProtocolKey.EXTRA_POINAME, rspGeoDecodeModel.getPoiName()));
        return rspGeoDecodeModel;
    }
}
