package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspGetAreaInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspGetAreaInfoModel> CREATOR = new a();
    public String address;
    public String areaCode;
    public String cityCode;
    public String cityName;
    public String countryCode;
    public String countryName;
    public String districyName;
    public String fullAddress;
    public double latitude;
    public double longitude;
    public String provinceName;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspGetAreaInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGetAreaInfoModel createFromParcel(Parcel parcel) {
            return new RspGetAreaInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGetAreaInfoModel[] newArray(int i) {
            return new RspGetAreaInfoModel[i];
        }
    }

    public RspGetAreaInfoModel() {
        setProtocolID(80030);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public String getCityName() {
        return this.cityName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getDistricyName() {
        return this.districyName;
    }

    public String getFullAddress() {
        return this.fullAddress;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 1;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public void setAreaCode(String str) {
        this.areaCode = str;
    }

    public void setCityCode(String str) {
        this.cityCode = str;
    }

    public void setCityName(String str) {
        this.cityName = str;
    }

    public void setCountryCode(String str) {
        this.countryCode = str;
    }

    public void setCountryName(String str) {
        this.countryName = str;
    }

    public void setDistricyName(String str) {
        this.districyName = str;
    }

    public void setFullAddress(String str) {
        this.fullAddress = str;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setProvinceName(String str) {
        this.provinceName = str;
    }

    public String toString() {
        return "areaCode: " + this.areaCode + "\ncityName: " + this.cityName + "\ncountryName: " + this.countryName + "\ndistricyName: " + this.districyName + "\nprovinceName: " + this.provinceName + "\nlongitude:" + this.longitude + "\nlatitude:" + this.latitude + "\ncountryCode:" + this.countryCode + "\ncityCode:" + this.cityCode + "\n" + StandardProtocolKey.POI_ADDRESS + ":" + this.address + "\nfullAddress:" + this.fullAddress + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.areaCode);
        parcel.writeString(this.cityName);
        parcel.writeString(this.countryName);
        parcel.writeString(this.districyName);
        parcel.writeString(this.provinceName);
        if (getDataVersion() >= 1) {
            parcel.writeDouble(this.longitude);
            parcel.writeDouble(this.latitude);
            parcel.writeString(this.countryCode);
            parcel.writeString(this.cityCode);
            parcel.writeString(this.address);
            parcel.writeString(this.fullAddress);
        }
    }

    public RspGetAreaInfoModel(String str, String str2, String str3, String str4, String str5) {
        setProtocolID(80030);
        this.areaCode = str;
        this.cityName = str2;
        this.countryName = str3;
        this.districyName = str4;
        this.provinceName = str5;
    }

    public RspGetAreaInfoModel(Parcel parcel) {
        super(parcel);
        this.areaCode = parcel.readString();
        this.cityName = parcel.readString();
        this.countryName = parcel.readString();
        this.districyName = parcel.readString();
        this.provinceName = parcel.readString();
        if (getDataVersion() >= 1) {
            this.longitude = parcel.readDouble();
            this.latitude = parcel.readDouble();
            this.countryCode = parcel.readString();
            this.cityCode = parcel.readString();
            this.address = parcel.readString();
            this.fullAddress = parcel.readString();
        }
    }
}
