package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspGetAreaInfoModel_JsonLubeParser implements Serializable {
    public static RspGetAreaInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspGetAreaInfoModel rspGetAreaInfoModel = new RspGetAreaInfoModel();
        rspGetAreaInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", rspGetAreaInfoModel.getClientPackageName()));
        rspGetAreaInfoModel.setPackageName(jSONObject.optString("packageName", rspGetAreaInfoModel.getPackageName()));
        rspGetAreaInfoModel.setCallbackId(jSONObject.optInt("callbackId", rspGetAreaInfoModel.getCallbackId()));
        rspGetAreaInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", rspGetAreaInfoModel.getTimeStamp()));
        rspGetAreaInfoModel.setVar1(jSONObject.optString("var1", rspGetAreaInfoModel.getVar1()));
        rspGetAreaInfoModel.setAreaCode(jSONObject.optString("areaCode", rspGetAreaInfoModel.getAreaCode()));
        rspGetAreaInfoModel.setCityName(jSONObject.optString("cityName", rspGetAreaInfoModel.getCityName()));
        rspGetAreaInfoModel.setCountryName(jSONObject.optString("countryName", rspGetAreaInfoModel.getCountryName()));
        rspGetAreaInfoModel.setDistricyName(jSONObject.optString("districyName", rspGetAreaInfoModel.getDistricyName()));
        rspGetAreaInfoModel.setProvinceName(jSONObject.optString("provinceName", rspGetAreaInfoModel.getProvinceName()));
        rspGetAreaInfoModel.setLongitude(jSONObject.optDouble("longitude", rspGetAreaInfoModel.getLongitude()));
        rspGetAreaInfoModel.setLatitude(jSONObject.optDouble("latitude", rspGetAreaInfoModel.getLatitude()));
        rspGetAreaInfoModel.setCountryCode(jSONObject.optString("countryCode", rspGetAreaInfoModel.getCountryCode()));
        rspGetAreaInfoModel.setCityCode(jSONObject.optString("cityCode", rspGetAreaInfoModel.getCityCode()));
        rspGetAreaInfoModel.setAddress(jSONObject.optString(StandardProtocolKey.POI_ADDRESS, rspGetAreaInfoModel.getAddress()));
        rspGetAreaInfoModel.setFullAddress(jSONObject.optString("fullAddress", rspGetAreaInfoModel.getFullAddress()));
        return rspGetAreaInfoModel;
    }
}
