package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspGetAreaInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspGetAreaInfoModel rspGetAreaInfoModel) throws JSONException {
        if (rspGetAreaInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspGetAreaInfoModel.getPackageName());
        jSONObject.put("clientPackageName", rspGetAreaInfoModel.getClientPackageName());
        jSONObject.put("callbackId", rspGetAreaInfoModel.getCallbackId());
        jSONObject.put("timeStamp", rspGetAreaInfoModel.getTimeStamp());
        jSONObject.put("var1", rspGetAreaInfoModel.getVar1());
        jSONObject.put("areaCode", rspGetAreaInfoModel.getAreaCode());
        jSONObject.put("cityName", rspGetAreaInfoModel.getCityName());
        jSONObject.put("countryName", rspGetAreaInfoModel.getCountryName());
        jSONObject.put("districyName", rspGetAreaInfoModel.getDistricyName());
        jSONObject.put("provinceName", rspGetAreaInfoModel.getProvinceName());
        jSONObject.put("longitude", rspGetAreaInfoModel.getLongitude());
        jSONObject.put("latitude", rspGetAreaInfoModel.getLatitude());
        jSONObject.put("countryCode", rspGetAreaInfoModel.getCountryCode());
        jSONObject.put("cityCode", rspGetAreaInfoModel.getCityCode());
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, rspGetAreaInfoModel.getAddress());
        jSONObject.put("fullAddress", rspGetAreaInfoModel.getFullAddress());
        return jSONObject;
    }
}
