package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import defpackage.o60;

@Keep
/* loaded from: classes.dex */
public class RspGetMapOperateResultModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspGetMapOperateResultModel> CREATOR = new a();
    public String cityName;
    public String districtName;
    public double entryLatitude;
    public double entryLongitude;

    @o60(isLonLat = true)
    public double latitude;

    @o60(isLonLat = true)
    public double longitude;
    public String phoneNumber;
    public String poiID;
    public String poiName;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspGetMapOperateResultModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGetMapOperateResultModel createFromParcel(Parcel parcel) {
            return new RspGetMapOperateResultModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspGetMapOperateResultModel[] newArray(int i) {
            return new RspGetMapOperateResultModel[i];
        }
    }

    public RspGetMapOperateResultModel() {
        setProtocolID(80157);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getCityName() {
        return this.cityName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public double getEntryLatitude() {
        return this.entryLatitude;
    }

    public double getEntryLongitude() {
        return this.entryLongitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPoiID() {
        return this.poiID;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public void setCityName(String str) {
        this.cityName = str;
    }

    public void setDistrictName(String str) {
        this.districtName = str;
    }

    public void setEntryLatitude(double d) {
        this.entryLatitude = d;
    }

    public void setEntryLongitude(double d) {
        this.entryLongitude = d;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setPhoneNumber(String str) {
        this.phoneNumber = str;
    }

    public void setPoiID(String str) {
        this.poiID = str;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public String toString() {
        return "cityName: " + this.cityName + "\ndistrictName: " + this.districtName + "\n" + StandardProtocolKey.EXTRA_ENTRYLATITUDE + ": " + this.entryLatitude + "\n" + StandardProtocolKey.EXTRA_ENTRYLONGITUDE + ": " + this.entryLongitude + "\nlatitude: " + this.latitude + "\nlongitude: " + this.longitude + "\n" + StandardProtocolKey.EXTRA_PHONENUMBER + ": " + this.phoneNumber + "\n" + StandardProtocolKey.EXTRA_POIID + ": " + this.poiID + "\n" + StandardProtocolKey.EXTRA_POINAME + ": " + this.poiName + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.cityName);
        parcel.writeString(this.districtName);
        parcel.writeDouble(this.entryLatitude);
        parcel.writeDouble(this.entryLongitude);
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.longitude);
        parcel.writeString(this.phoneNumber);
        parcel.writeString(this.poiID);
        parcel.writeString(this.poiName);
    }

    public RspGetMapOperateResultModel(Parcel parcel) {
        super(parcel);
        this.cityName = parcel.readString();
        this.districtName = parcel.readString();
        this.entryLatitude = parcel.readDouble();
        this.entryLongitude = parcel.readDouble();
        this.latitude = parcel.readDouble();
        this.longitude = parcel.readDouble();
        this.phoneNumber = parcel.readString();
        this.poiID = parcel.readString();
        this.poiName = parcel.readString();
    }
}
