package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.HistoryPoiInfo;
import com.autonavi.amapauto.protocol.model.item.HistoryPoiInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspHistoryOutputModel_JsonLubeParser implements Serializable {
    public static RspHistoryOutputModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspHistoryOutputModel rspHistoryOutputModel = new RspHistoryOutputModel();
        rspHistoryOutputModel.setClientPackageName(jSONObject.optString("clientPackageName", rspHistoryOutputModel.getClientPackageName()));
        rspHistoryOutputModel.setPackageName(jSONObject.optString("packageName", rspHistoryOutputModel.getPackageName()));
        rspHistoryOutputModel.setCallbackId(jSONObject.optInt("callbackId", rspHistoryOutputModel.getCallbackId()));
        rspHistoryOutputModel.setTimeStamp(jSONObject.optLong("timeStamp", rspHistoryOutputModel.getTimeStamp()));
        rspHistoryOutputModel.setVar1(jSONObject.optString("var1", rspHistoryOutputModel.getVar1()));
        JSONArray optJSONArray = jSONObject.optJSONArray("historyPoiList");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<HistoryPoiInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(HistoryPoiInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            rspHistoryOutputModel.setHistoryPoiList(arrayList);
        }
        return rspHistoryOutputModel;
    }
}
