package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.HistoryPoiInfo;
import com.autonavi.amapauto.protocol.model.item.HistoryPoiInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspHistoryOutputModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspHistoryOutputModel rspHistoryOutputModel) throws JSONException {
        if (rspHistoryOutputModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspHistoryOutputModel.getPackageName());
        jSONObject.put("clientPackageName", rspHistoryOutputModel.getClientPackageName());
        jSONObject.put("callbackId", rspHistoryOutputModel.getCallbackId());
        jSONObject.put("timeStamp", rspHistoryOutputModel.getTimeStamp());
        jSONObject.put("var1", rspHistoryOutputModel.getVar1());
        if (rspHistoryOutputModel.getHistoryPoiList() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<HistoryPoiInfo> it = rspHistoryOutputModel.getHistoryPoiList().iterator();
            while (it.hasNext()) {
                HistoryPoiInfo next = it.next();
                if (next != null) {
                    jSONArray.put(HistoryPoiInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("historyPoiList", jSONArray);
        }
        return jSONObject;
    }
}
