package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspPOIInfoShareModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspPOIInfoShareModel> CREATOR = new a();
    public String address;
    public int distance;
    public double entry_latitude;
    public double entry_longitude;
    public int homecopType;
    public double latitude;
    public double longitude;
    public String poiId;
    public String poiName;
    public String tel;
    public int typeCode;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspPOIInfoShareModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspPOIInfoShareModel createFromParcel(Parcel parcel) {
            return new RspPOIInfoShareModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspPOIInfoShareModel[] newArray(int i) {
            return new RspPOIInfoShareModel[i];
        }
    }

    public RspPOIInfoShareModel() {
        setProtocolID(80109);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getEntry_latitude() {
        return this.entry_latitude;
    }

    public double getEntry_longitude() {
        return this.entry_longitude;
    }

    public int getHomecopType() {
        return this.homecopType;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getPoiId() {
        return this.poiId;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public String getTel() {
        return this.tel;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public void setDistance(int i) {
        this.distance = i;
    }

    public void setEntry_latitude(double d) {
        this.entry_latitude = d;
    }

    public void setEntry_longitude(double d) {
        this.entry_longitude = d;
    }

    public void setHomecopType(int i) {
        this.homecopType = i;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public void setPoiId(String str) {
        this.poiId = str;
    }

    public void setPoiName(String str) {
        this.poiName = str;
    }

    public void setTel(String str) {
        this.tel = str;
    }

    public void setTypeCode(int i) {
        this.typeCode = i;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_POINAME + ": " + this.poiName + "\n" + StandardProtocolKey.ENTRY_LATITUDE + ": " + this.entry_latitude + "\n" + StandardProtocolKey.POI_DISTANCE + ": " + this.distance + "\nhomecopType: " + this.homecopType + "\nlongitude: " + this.longitude + "\n" + StandardProtocolKey.POI_ADDRESS + ": " + this.address + "\n" + StandardProtocolKey.POI_ID + ": " + this.poiId + "\n" + StandardProtocolKey.TEL + ": " + this.tel + "\ntypeCode: " + this.typeCode + "\n" + StandardProtocolKey.ENTRY_LONGITUDE + ": " + this.entry_longitude + "\nlatitude: " + this.latitude + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.poiName);
        parcel.writeDouble(this.entry_latitude);
        parcel.writeInt(this.distance);
        parcel.writeDouble(this.longitude);
        parcel.writeString(this.address);
        parcel.writeString(this.poiId);
        parcel.writeString(this.tel);
        parcel.writeInt(this.typeCode);
        parcel.writeDouble(this.entry_longitude);
        parcel.writeDouble(this.latitude);
        parcel.writeInt(this.homecopType);
    }

    public RspPOIInfoShareModel(Parcel parcel) {
        super(parcel);
        this.poiName = parcel.readString();
        this.entry_latitude = parcel.readDouble();
        this.distance = parcel.readInt();
        this.longitude = parcel.readDouble();
        this.address = parcel.readString();
        this.poiId = parcel.readString();
        this.tel = parcel.readString();
        this.typeCode = parcel.readInt();
        this.entry_longitude = parcel.readDouble();
        this.latitude = parcel.readDouble();
        this.homecopType = parcel.readInt();
    }
}
