package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspPathConfigInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspPathConfigInfoModel> CREATOR = new a();
    public String activatePath;
    public String audioPath;
    public String logPath;
    public String mapDataPath;
    public String userDataPath;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspPathConfigInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspPathConfigInfoModel createFromParcel(Parcel parcel) {
            return new RspPathConfigInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspPathConfigInfoModel[] newArray(int i) {
            return new RspPathConfigInfoModel[i];
        }
    }

    public RspPathConfigInfoModel() {
        setProtocolID(80129);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getActivatePath() {
        return this.activatePath;
    }

    public String getAudioPath() {
        return this.audioPath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String getMapDataPath() {
        return this.mapDataPath;
    }

    public String getUserDataPath() {
        return this.userDataPath;
    }

    public void setActivatePath(String str) {
        this.activatePath = str;
    }

    public void setAudioPath(String str) {
        this.audioPath = str;
    }

    public void setLogPath(String str) {
        this.logPath = str;
    }

    public void setMapDataPath(String str) {
        this.mapDataPath = str;
    }

    public void setUserDataPath(String str) {
        this.userDataPath = str;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_ACTIVATEPATH + ": " + this.activatePath + "\n" + StandardProtocolKey.EXTRA_AUDIOPATH + ": " + this.audioPath + "\n" + StandardProtocolKey.EXTRA_LOGPATH + ": " + this.logPath + "\n" + StandardProtocolKey.EXTRA_MAPDATAPATH + ": " + this.mapDataPath + "\n" + StandardProtocolKey.EXTRA_USERDATAPATH + ": " + this.userDataPath + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeString(this.activatePath);
        parcel.writeString(this.audioPath);
        parcel.writeString(this.logPath);
        parcel.writeString(this.mapDataPath);
        parcel.writeString(this.userDataPath);
    }

    public RspPathConfigInfoModel(Parcel parcel) {
        super(parcel);
        this.activatePath = parcel.readString();
        this.audioPath = parcel.readString();
        this.logPath = parcel.readString();
        this.mapDataPath = parcel.readString();
        this.userDataPath = parcel.readString();
    }
}
