package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspPathConfigInfoModel_JsonLubeParser implements Serializable {
    public static RspPathConfigInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspPathConfigInfoModel rspPathConfigInfoModel = new RspPathConfigInfoModel();
        rspPathConfigInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", rspPathConfigInfoModel.getClientPackageName()));
        rspPathConfigInfoModel.setPackageName(jSONObject.optString("packageName", rspPathConfigInfoModel.getPackageName()));
        rspPathConfigInfoModel.setCallbackId(jSONObject.optInt("callbackId", rspPathConfigInfoModel.getCallbackId()));
        rspPathConfigInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", rspPathConfigInfoModel.getTimeStamp()));
        rspPathConfigInfoModel.setVar1(jSONObject.optString("var1", rspPathConfigInfoModel.getVar1()));
        rspPathConfigInfoModel.setActivatePath(jSONObject.optString(StandardProtocolKey.EXTRA_ACTIVATEPATH, rspPathConfigInfoModel.getActivatePath()));
        rspPathConfigInfoModel.setAudioPath(jSONObject.optString(StandardProtocolKey.EXTRA_AUDIOPATH, rspPathConfigInfoModel.getAudioPath()));
        rspPathConfigInfoModel.setLogPath(jSONObject.optString(StandardProtocolKey.EXTRA_LOGPATH, rspPathConfigInfoModel.getLogPath()));
        rspPathConfigInfoModel.setMapDataPath(jSONObject.optString(StandardProtocolKey.EXTRA_MAPDATAPATH, rspPathConfigInfoModel.getMapDataPath()));
        rspPathConfigInfoModel.setUserDataPath(jSONObject.optString(StandardProtocolKey.EXTRA_USERDATAPATH, rspPathConfigInfoModel.getUserDataPath()));
        return rspPathConfigInfoModel;
    }
}
