package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspPathConfigInfoModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspPathConfigInfoModel rspPathConfigInfoModel) throws JSONException {
        if (rspPathConfigInfoModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspPathConfigInfoModel.getPackageName());
        jSONObject.put("clientPackageName", rspPathConfigInfoModel.getClientPackageName());
        jSONObject.put("callbackId", rspPathConfigInfoModel.getCallbackId());
        jSONObject.put("timeStamp", rspPathConfigInfoModel.getTimeStamp());
        jSONObject.put("var1", rspPathConfigInfoModel.getVar1());
        jSONObject.put(StandardProtocolKey.EXTRA_ACTIVATEPATH, rspPathConfigInfoModel.getActivatePath());
        jSONObject.put(StandardProtocolKey.EXTRA_AUDIOPATH, rspPathConfigInfoModel.getAudioPath());
        jSONObject.put(StandardProtocolKey.EXTRA_LOGPATH, rspPathConfigInfoModel.getLogPath());
        jSONObject.put(StandardProtocolKey.EXTRA_MAPDATAPATH, rspPathConfigInfoModel.getMapDataPath());
        jSONObject.put(StandardProtocolKey.EXTRA_USERDATAPATH, rspPathConfigInfoModel.getUserDataPath());
        return jSONObject;
    }
}
