package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.model.item.FavoriteData;
import com.autonavi.amapauto.protocol.model.item.FavoriteData_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspQuerySavesModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspQuerySavesModel rspQuerySavesModel) throws JSONException {
        if (rspQuerySavesModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspQuerySavesModel.getPackageName());
        jSONObject.put("clientPackageName", rspQuerySavesModel.getClientPackageName());
        jSONObject.put("callbackId", rspQuerySavesModel.getCallbackId());
        jSONObject.put("timeStamp", rspQuerySavesModel.getTimeStamp());
        jSONObject.put("var1", rspQuerySavesModel.getVar1());
        if (rspQuerySavesModel.getFavoriteData() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<FavoriteData> it = rspQuerySavesModel.getFavoriteData().iterator();
            while (it.hasNext()) {
                FavoriteData next = it.next();
                if (next != null) {
                    jSONArray.put(FavoriteData_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("favoriteData", jSONArray);
        }
        return jSONObject;
    }
}
