package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspResidualEnergyInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspResidualEnergyInfoModel> CREATOR = new a();
    public double percentOfResidualEnergy;
    public double residualEnergy;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspResidualEnergyInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspResidualEnergyInfoModel createFromParcel(Parcel parcel) {
            return new RspResidualEnergyInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspResidualEnergyInfoModel[] newArray(int i) {
            return new RspResidualEnergyInfoModel[i];
        }
    }

    public RspResidualEnergyInfoModel() {
        setProtocolID(80050);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public double getPercentOfResidualEnergy() {
        return this.percentOfResidualEnergy;
    }

    public double getResidualEnergy() {
        return this.residualEnergy;
    }

    public void setPercentOfResidualEnergy(double d) {
        this.percentOfResidualEnergy = d;
    }

    public void setResidualEnergy(double d) {
        this.residualEnergy = d;
    }

    public String toString() {
        return StandardProtocolKey.EXTRA_PERCENT_OF_RESIDUAL_ENERGY + ": " + this.percentOfResidualEnergy + "\n" + StandardProtocolKey.EXTRA_RESIDUAL_ENERGY + ": " + this.residualEnergy + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeDouble(this.percentOfResidualEnergy);
        parcel.writeDouble(this.residualEnergy);
    }

    public RspResidualEnergyInfoModel(double d, double d2) {
        this.percentOfResidualEnergy = d;
        this.residualEnergy = d2;
        setProtocolID(80050);
    }

    public RspResidualEnergyInfoModel(Parcel parcel) {
        super(parcel);
        this.percentOfResidualEnergy = parcel.readDouble();
        this.residualEnergy = parcel.readDouble();
    }
}
