package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspResidualEnergyInfoModel_JsonLubeParser implements Serializable {
    public static RspResidualEnergyInfoModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspResidualEnergyInfoModel rspResidualEnergyInfoModel = new RspResidualEnergyInfoModel();
        rspResidualEnergyInfoModel.setClientPackageName(jSONObject.optString("clientPackageName", rspResidualEnergyInfoModel.getClientPackageName()));
        rspResidualEnergyInfoModel.setPackageName(jSONObject.optString("packageName", rspResidualEnergyInfoModel.getPackageName()));
        rspResidualEnergyInfoModel.setCallbackId(jSONObject.optInt("callbackId", rspResidualEnergyInfoModel.getCallbackId()));
        rspResidualEnergyInfoModel.setTimeStamp(jSONObject.optLong("timeStamp", rspResidualEnergyInfoModel.getTimeStamp()));
        rspResidualEnergyInfoModel.setVar1(jSONObject.optString("var1", rspResidualEnergyInfoModel.getVar1()));
        rspResidualEnergyInfoModel.setPercentOfResidualEnergy(jSONObject.optDouble(StandardProtocolKey.EXTRA_PERCENT_OF_RESIDUAL_ENERGY, rspResidualEnergyInfoModel.getPercentOfResidualEnergy()));
        rspResidualEnergyInfoModel.setResidualEnergy(jSONObject.optDouble(StandardProtocolKey.EXTRA_RESIDUAL_ENERGY, rspResidualEnergyInfoModel.getResidualEnergy()));
        return rspResidualEnergyInfoModel;
    }
}
