package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.Route;
import java.util.ArrayList;

@Keep
/* loaded from: classes.dex */
public class RspRouteInfoContrastModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspRouteInfoContrastModel> CREATOR = new a();
    public ArrayList<Route> route;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspRouteInfoContrastModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspRouteInfoContrastModel createFromParcel(Parcel parcel) {
            return new RspRouteInfoContrastModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspRouteInfoContrastModel[] newArray(int i) {
            return new RspRouteInfoContrastModel[i];
        }
    }

    public RspRouteInfoContrastModel() {
        setProtocolID(80155);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public ArrayList<Route> getRoute() {
        return this.route;
    }

    public void setRoute(ArrayList<Route> arrayList) {
        this.route = arrayList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StandardProtocolKey.EXTRA_ROUTE);
        sb.append(": ");
        ArrayList<Route> arrayList = this.route;
        sb.append(arrayList != null ? arrayList.toString() : "null");
        sb.append("\n");
        return sb.toString();
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeTypedList(this.route);
    }

    public RspRouteInfoContrastModel(Parcel parcel) {
        super(parcel);
        this.route = parcel.createTypedArrayList(Route.CREATOR);
    }
}
