package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.Route;
import com.autonavi.amapauto.protocol.model.item.Route_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspRouteInfoContrastModel_JsonLubeParser implements Serializable {
    public static RspRouteInfoContrastModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        RspRouteInfoContrastModel rspRouteInfoContrastModel = new RspRouteInfoContrastModel();
        rspRouteInfoContrastModel.setClientPackageName(jSONObject.optString("clientPackageName", rspRouteInfoContrastModel.getClientPackageName()));
        rspRouteInfoContrastModel.setPackageName(jSONObject.optString("packageName", rspRouteInfoContrastModel.getPackageName()));
        rspRouteInfoContrastModel.setCallbackId(jSONObject.optInt("callbackId", rspRouteInfoContrastModel.getCallbackId()));
        rspRouteInfoContrastModel.setTimeStamp(jSONObject.optLong("timeStamp", rspRouteInfoContrastModel.getTimeStamp()));
        rspRouteInfoContrastModel.setVar1(jSONObject.optString("var1", rspRouteInfoContrastModel.getVar1()));
        JSONArray optJSONArray = jSONObject.optJSONArray(StandardProtocolKey.EXTRA_ROUTE);
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<Route> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(Route_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            rspRouteInfoContrastModel.setRoute(arrayList);
        }
        return rspRouteInfoContrastModel;
    }
}
