package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.item.Route;
import com.autonavi.amapauto.protocol.model.item.Route_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class RspRouteInfoContrastModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(RspRouteInfoContrastModel rspRouteInfoContrastModel) throws JSONException {
        if (rspRouteInfoContrastModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", rspRouteInfoContrastModel.getPackageName());
        jSONObject.put("clientPackageName", rspRouteInfoContrastModel.getClientPackageName());
        jSONObject.put("callbackId", rspRouteInfoContrastModel.getCallbackId());
        jSONObject.put("timeStamp", rspRouteInfoContrastModel.getTimeStamp());
        jSONObject.put("var1", rspRouteInfoContrastModel.getVar1());
        if (rspRouteInfoContrastModel.getRoute() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<Route> it = rspRouteInfoContrastModel.getRoute().iterator();
            while (it.hasNext()) {
                Route next = it.next();
                if (next != null) {
                    jSONArray.put(Route_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put(StandardProtocolKey.EXTRA_ROUTE, jSONArray);
        }
        return jSONObject;
    }
}
