package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspSearchNavInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspSearchNavInfoModel> CREATOR = new a();
    public int cameraDist;
    public int cameraID;
    public boolean cameraPenalty;
    public int cameraSpeed;
    public int cameraType;
    public boolean isOverspeed;
    public int sapaDist;
    public int sapaETA;
    public String sapaName;
    public int sapaNum;
    public int sapaType;
    public int tollDist;
    public int tollETA;
    public String tollName;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspSearchNavInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspSearchNavInfoModel createFromParcel(Parcel parcel) {
            return new RspSearchNavInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspSearchNavInfoModel[] newArray(int i) {
            return new RspSearchNavInfoModel[i];
        }
    }

    public RspSearchNavInfoModel() {
        this.cameraDist = 0;
        this.cameraID = 0;
        this.cameraPenalty = false;
        this.cameraSpeed = 0;
        this.cameraType = -1;
        this.isOverspeed = false;
        this.sapaDist = -1;
        this.sapaETA = -1;
        this.sapaNum = 0;
        this.sapaType = -1;
        this.tollDist = -1;
        this.tollETA = -1;
        setProtocolID(80163);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getCameraDist() {
        return this.cameraDist;
    }

    public int getCameraID() {
        return this.cameraID;
    }

    public boolean getCameraPenalty() {
        return this.cameraPenalty;
    }

    public int getCameraSpeed() {
        return this.cameraSpeed;
    }

    public int getCameraType() {
        return this.cameraType;
    }

    public boolean getIsOverspeed() {
        return this.isOverspeed;
    }

    public int getSapaDist() {
        return this.sapaDist;
    }

    public int getSapaETA() {
        return this.sapaETA;
    }

    public String getSapaName() {
        return this.sapaName;
    }

    public int getSapaNum() {
        return this.sapaNum;
    }

    public int getSapaType() {
        return this.sapaType;
    }

    public int getTollDist() {
        return this.tollDist;
    }

    public int getTollETA() {
        return this.tollETA;
    }

    public String getTollName() {
        return this.tollName;
    }

    public void setCameraDist(int i) {
        this.cameraDist = i;
    }

    public void setCameraID(int i) {
        this.cameraID = i;
    }

    public void setCameraPenalty(boolean z) {
        this.cameraPenalty = z;
    }

    public void setCameraSpeed(int i) {
        this.cameraSpeed = i;
    }

    public void setCameraType(int i) {
        this.cameraType = i;
    }

    public void setIsOverspeed(boolean z) {
        this.isOverspeed = z;
    }

    public void setSapaDist(int i) {
        this.sapaDist = i;
    }

    public void setSapaETA(int i) {
        this.sapaETA = i;
    }

    public void setSapaName(String str) {
        this.sapaName = str;
    }

    public void setSapaNum(int i) {
        this.sapaNum = i;
    }

    public void setSapaType(int i) {
        this.sapaType = i;
    }

    public void setTollDist(int i) {
        this.tollDist = i;
    }

    public void setTollETA(int i) {
        this.tollETA = i;
    }

    public void setTollName(String str) {
        this.tollName = str;
    }

    public String toString() {
        return "cameraDist: " + this.cameraDist + "\ncameraID: " + this.cameraID + "\ncameraPenalty: " + this.cameraPenalty + "\ncameraSpeed: " + this.cameraSpeed + "\ncameraType: " + this.cameraType + "\nisOverspeed: " + this.isOverspeed + "\nsapaDist: " + this.sapaDist + "\nsapaETA: " + this.sapaETA + "\nsapaName: " + this.sapaName + "\nsapaNum: " + this.sapaNum + "\nsapaType: " + this.sapaType + "\ntollDist: " + this.tollDist + "\ntollETA: " + this.tollETA + "\ntollName: " + this.tollName + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.cameraDist);
        parcel.writeInt(this.cameraID);
        parcel.writeByte(this.cameraPenalty ? (byte) 1 : (byte) 0);
        parcel.writeInt(this.cameraSpeed);
        parcel.writeInt(this.cameraType);
        parcel.writeByte(this.isOverspeed ? (byte) 1 : (byte) 0);
        parcel.writeInt(this.sapaDist);
        parcel.writeInt(this.sapaETA);
        parcel.writeString(this.sapaName);
        parcel.writeInt(this.sapaNum);
        parcel.writeInt(this.sapaType);
        parcel.writeInt(this.tollDist);
        parcel.writeInt(this.tollETA);
        parcel.writeString(this.tollName);
    }

    public RspSearchNavInfoModel(Parcel parcel) {
        super(parcel);
        this.cameraDist = 0;
        this.cameraID = 0;
        this.cameraPenalty = false;
        this.cameraSpeed = 0;
        this.cameraType = -1;
        this.isOverspeed = false;
        this.sapaDist = -1;
        this.sapaETA = -1;
        this.sapaNum = 0;
        this.sapaType = -1;
        this.tollDist = -1;
        this.tollETA = -1;
        this.cameraDist = parcel.readInt();
        this.cameraID = parcel.readInt();
        this.cameraPenalty = parcel.readByte() != 0;
        this.cameraSpeed = parcel.readInt();
        this.cameraType = parcel.readInt();
        this.isOverspeed = parcel.readByte() != 0;
        this.sapaDist = parcel.readInt();
        this.sapaETA = parcel.readInt();
        this.sapaName = parcel.readString();
        this.sapaNum = parcel.readInt();
        this.sapaType = parcel.readInt();
        this.tollDist = parcel.readInt();
        this.tollETA = parcel.readInt();
        this.tollName = parcel.readString();
    }
}
