package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspSendDesInfoLastMileModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspSendDesInfoLastMileModel> CREATOR = new a();
    public String address;
    public int distance;
    public double entryLat;
    public double entryLon;
    public String name;
    public String phone;
    public String poiTypeCode;
    public String poiid;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspSendDesInfoLastMileModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspSendDesInfoLastMileModel createFromParcel(Parcel parcel) {
            return new RspSendDesInfoLastMileModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspSendDesInfoLastMileModel[] newArray(int i) {
            return new RspSendDesInfoLastMileModel[i];
        }
    }

    public RspSendDesInfoLastMileModel() {
        setProtocolID(80068);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.address;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getEntryLat() {
        return this.entryLat;
    }

    public double getEntryLon() {
        return this.entryLon;
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel
    public int getModelVersion() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPoiTypeCode() {
        return this.poiTypeCode;
    }

    public String getPoiid() {
        return this.poiid;
    }

    public void setAddress(String str) {
        this.address = str;
    }

    public void setDistance(int i) {
        this.distance = i;
    }

    public void setEntryLat(double d) {
        this.entryLat = d;
    }

    public void setEntryLon(double d) {
        this.entryLon = d;
    }

    public void setName(String str) {
        this.name = str;
    }

    public void setPhone(String str) {
        this.phone = str;
    }

    public void setPoiTypeCode(String str) {
        this.poiTypeCode = str;
    }

    public void setPoiid(String str) {
        this.poiid = str;
    }

    public String toString() {
        return StandardProtocolKey.POI_ADDRESS + ": " + this.address + "\n" + StandardProtocolKey.NAME + ": " + this.name + "\nentryLat: " + this.entryLat + "\nentryLon: " + this.entryLon + "\n" + StandardProtocolKey.POIID + ": " + this.poiid + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeDouble(this.entryLon);
        parcel.writeString(this.name);
        parcel.writeDouble(this.entryLat);
        parcel.writeString(this.address);
        if (getDataVersion() >= 1) {
            parcel.writeString(this.poiid);
        }
        if (getDataVersion() >= 2) {
            parcel.writeInt(this.distance);
            parcel.writeString(this.poiTypeCode);
            parcel.writeString(this.phone);
        }
    }

    public RspSendDesInfoLastMileModel(double d, String str, double d2, String str2) {
        this.entryLon = d;
        this.name = str;
        this.entryLat = d2;
        this.address = str2;
        setProtocolID(80068);
    }

    public RspSendDesInfoLastMileModel(Parcel parcel) {
        super(parcel);
        this.entryLon = parcel.readDouble();
        this.name = parcel.readString();
        this.entryLat = parcel.readDouble();
        this.address = parcel.readString();
        if (getDataVersion() >= 1) {
            this.poiid = parcel.readString();
        }
        if (getDataVersion() >= 2) {
            this.distance = parcel.readInt();
            this.poiTypeCode = parcel.readString();
            this.phone = parcel.readString();
        }
    }
}
