package com.autonavi.amapauto.protocol.model.service;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;

@Keep
/* loaded from: classes.dex */
public class RspTrafficLightsCountdownInfoModel extends ProtocolBaseModel {
    public static final Parcelable.Creator<RspTrafficLightsCountdownInfoModel> CREATOR = new a();
    public int dir;
    public int redLightCountDownSeconds;
    public int trafficLightStatus;
    public int waitRound;

    /* loaded from: classes.dex */
    public static class a implements Parcelable.Creator<RspTrafficLightsCountdownInfoModel> {
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspTrafficLightsCountdownInfoModel createFromParcel(Parcel parcel) {
            return new RspTrafficLightsCountdownInfoModel(parcel);
        }

        /* JADX WARN: Can't rename method to resolve collision */
        @Override // android.os.Parcelable.Creator
        public RspTrafficLightsCountdownInfoModel[] newArray(int i) {
            return new RspTrafficLightsCountdownInfoModel[i];
        }
    }

    public RspTrafficLightsCountdownInfoModel() {
        this.dir = 0;
        this.redLightCountDownSeconds = 0;
        this.trafficLightStatus = 0;
        this.waitRound = 0;
        setProtocolID(80189);
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    public int getDir() {
        return this.dir;
    }

    public int getRedLightCountDownSeconds() {
        return this.redLightCountDownSeconds;
    }

    public int getTrafficLightStatus() {
        return this.trafficLightStatus;
    }

    public int getWaitRound() {
        return this.waitRound;
    }

    public void setDir(int i) {
        this.dir = i;
    }

    public void setRedLightCountDownSeconds(int i) {
        this.redLightCountDownSeconds = i;
    }

    public void setTrafficLightStatus(int i) {
        this.trafficLightStatus = i;
    }

    public void setWaitRound(int i) {
        this.waitRound = i;
    }

    public String toString() {
        return "dir: " + this.dir + "\n" + StandardProtocolKey.EXTRA_REDLIGHTCOUNTDOWNSECONDS + ": " + this.redLightCountDownSeconds + "\n" + StandardProtocolKey.EXTRA_TRAFFICLIGHTSTATUS + ": " + this.trafficLightStatus + "\n" + StandardProtocolKey.EXTRA_WAITROUND + ": " + this.waitRound + "\n";
    }

    @Override // com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel, android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        parcel.writeInt(this.dir);
        parcel.writeInt(this.redLightCountDownSeconds);
        parcel.writeInt(this.trafficLightStatus);
        parcel.writeInt(this.waitRound);
    }

    public RspTrafficLightsCountdownInfoModel(Parcel parcel) {
        super(parcel);
        this.dir = 0;
        this.redLightCountDownSeconds = 0;
        this.trafficLightStatus = 0;
        this.waitRound = 0;
        this.dir = parcel.readInt();
        this.redLightCountDownSeconds = parcel.readInt();
        this.trafficLightStatus = parcel.readInt();
        this.waitRound = parcel.readInt();
    }
}
