package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TmcItemInfo_JsonLubeParser implements Serializable {
    public static TmcItemInfo parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        TmcItemInfo tmcItemInfo = new TmcItemInfo();
        tmcItemInfo.setClientPackageName(jSONObject.optString("clientPackageName", tmcItemInfo.getClientPackageName()));
        tmcItemInfo.setPackageName(jSONObject.optString("packageName", tmcItemInfo.getPackageName()));
        tmcItemInfo.setCallbackId(jSONObject.optInt("callbackId", tmcItemInfo.getCallbackId()));
        tmcItemInfo.setTimeStamp(jSONObject.optLong("timeStamp", tmcItemInfo.getTimeStamp()));
        tmcItemInfo.setVar1(jSONObject.optString("var1", tmcItemInfo.getVar1()));
        tmcItemInfo.c(jSONObject.optInt("number", tmcItemInfo.n()));
        tmcItemInfo.d(jSONObject.optInt("status", tmcItemInfo.p()));
        tmcItemInfo.setDistance(jSONObject.optInt(StandardProtocolKey.POI_DISTANCE, tmcItemInfo.getDistance()));
        tmcItemInfo.a((float) jSONObject.optDouble("percent", tmcItemInfo.o()));
        tmcItemInfo.e(jSONObject.optInt("travelTime", tmcItemInfo.q()));
        return tmcItemInfo;
    }
}
