package com.autonavi.amapauto.protocol.model.service;

import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TmcItemInfo_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(TmcItemInfo tmcItemInfo) throws JSONException {
        if (tmcItemInfo == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", tmcItemInfo.getPackageName());
        jSONObject.put("clientPackageName", tmcItemInfo.getClientPackageName());
        jSONObject.put("callbackId", tmcItemInfo.getCallbackId());
        jSONObject.put("timeStamp", tmcItemInfo.getTimeStamp());
        jSONObject.put("var1", tmcItemInfo.getVar1());
        jSONObject.put("number", tmcItemInfo.n());
        jSONObject.put("status", tmcItemInfo.p());
        jSONObject.put(StandardProtocolKey.POI_DISTANCE, tmcItemInfo.getDistance());
        jSONObject.put("percent", tmcItemInfo.o());
        jSONObject.put("travelTime", tmcItemInfo.q());
        return jSONObject;
    }
}
