package com.autonavi.amapauto.protocol.model.service;

import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class TmcSegmentModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(TmcSegmentModel tmcSegmentModel) throws JSONException {
        if (tmcSegmentModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", tmcSegmentModel.getPackageName());
        jSONObject.put("clientPackageName", tmcSegmentModel.getClientPackageName());
        jSONObject.put("callbackId", tmcSegmentModel.getCallbackId());
        jSONObject.put("timeStamp", tmcSegmentModel.getTimeStamp());
        jSONObject.put("var1", tmcSegmentModel.getVar1());
        jSONObject.put("tmcEnabled", tmcSegmentModel.r());
        jSONObject.put("size", tmcSegmentModel.q());
        jSONObject.put("totalDistance", tmcSegmentModel.t());
        jSONObject.put("remainDistance", tmcSegmentModel.o());
        jSONObject.put("finishDistance", tmcSegmentModel.n());
        if (tmcSegmentModel.s() != null) {
            JSONArray jSONArray = new JSONArray();
            for (TmcItemInfo tmcItemInfo : tmcSegmentModel.s()) {
                if (tmcItemInfo != null) {
                    jSONArray.put(TmcItemInfo_JsonLubeSerializer.serialize(tmcItemInfo));
                }
            }
            jSONObject.put("tmcInfoList", jSONArray);
        }
        jSONObject.put("totalTime", tmcSegmentModel.u());
        jSONObject.put("remainTime", tmcSegmentModel.p());
        return jSONObject;
    }
}
