package com.autonavi.amapauto.protocol.model.service.user;

import com.autonavi.amapauto.protocol.model.item.FavoritePoiInfo;
import com.autonavi.amapauto.protocol.model.item.FavoritePoiInfo_JsonLubeParser;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class FavoritePoiModel_JsonLubeParser implements Serializable {
    public static FavoritePoiModel parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        FavoritePoiModel favoritePoiModel = new FavoritePoiModel();
        favoritePoiModel.setClientPackageName(jSONObject.optString("clientPackageName", favoritePoiModel.getClientPackageName()));
        favoritePoiModel.setPackageName(jSONObject.optString("packageName", favoritePoiModel.getPackageName()));
        favoritePoiModel.setCallbackId(jSONObject.optInt("callbackId", favoritePoiModel.getCallbackId()));
        favoritePoiModel.setTimeStamp(jSONObject.optLong("timeStamp", favoritePoiModel.getTimeStamp()));
        favoritePoiModel.setVar1(jSONObject.optString("var1", favoritePoiModel.getVar1()));
        JSONArray optJSONArray = jSONObject.optJSONArray("protocolFavPoiInfos");
        if (optJSONArray != null) {
            int length = optJSONArray.length();
            ArrayList<FavoritePoiInfo> arrayList = new ArrayList<>(length);
            for (int i = 0; i < length; i++) {
                arrayList.add(FavoritePoiInfo_JsonLubeParser.parse(optJSONArray.optJSONObject(i)));
            }
            favoritePoiModel.a(arrayList);
        }
        return favoritePoiModel;
    }
}
