package com.autonavi.amapauto.protocol.model.service.user;

import com.autonavi.amapauto.protocol.model.item.FavoritePoiInfo;
import com.autonavi.amapauto.protocol.model.item.FavoritePoiInfo_JsonLubeSerializer;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class FavoritePoiModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(FavoritePoiModel favoritePoiModel) throws JSONException {
        if (favoritePoiModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", favoritePoiModel.getPackageName());
        jSONObject.put("clientPackageName", favoritePoiModel.getClientPackageName());
        jSONObject.put("callbackId", favoritePoiModel.getCallbackId());
        jSONObject.put("timeStamp", favoritePoiModel.getTimeStamp());
        jSONObject.put("var1", favoritePoiModel.getVar1());
        if (favoritePoiModel.n() != null) {
            JSONArray jSONArray = new JSONArray();
            Iterator<FavoritePoiInfo> it = favoritePoiModel.n().iterator();
            while (it.hasNext()) {
                FavoritePoiInfo next = it.next();
                if (next != null) {
                    jSONArray.put(FavoritePoiInfo_JsonLubeSerializer.serialize(next));
                }
            }
            jSONObject.put("protocolFavPoiInfos", jSONArray);
        }
        return jSONObject;
    }
}
