package com.autonavi.amapauto.protocol.model.service.user;

import com.autonavi.amapauto.protocol.model.item.HistoryPoiInfo;
import com.autonavi.amapauto.protocol.model.item.HistoryPoiInfo_JsonLubeSerializer;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class ResponseHistoryPoiModel_JsonLubeSerializer implements Serializable {
    public static JSONObject serialize(ResponseHistoryPoiModel responseHistoryPoiModel) throws JSONException {
        if (responseHistoryPoiModel == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("packageName", responseHistoryPoiModel.getPackageName());
        jSONObject.put("clientPackageName", responseHistoryPoiModel.getClientPackageName());
        jSONObject.put("callbackId", responseHistoryPoiModel.getCallbackId());
        jSONObject.put("timeStamp", responseHistoryPoiModel.getTimeStamp());
        jSONObject.put("var1", responseHistoryPoiModel.getVar1());
        if (responseHistoryPoiModel.getHistoryPoiList() != null) {
            JSONArray jSONArray = new JSONArray();
            for (HistoryPoiInfo historyPoiInfo : responseHistoryPoiModel.getHistoryPoiList()) {
                if (historyPoiInfo != null) {
                    jSONArray.put(HistoryPoiInfo_JsonLubeSerializer.serialize(historyPoiInfo));
                }
            }
            jSONObject.put("historyPoiList", jSONArray);
        }
        return jSONObject;
    }
}
