package com.autonavi.amapauto.remotecontrol;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import defpackage.aa0;
import defpackage.ee;
import defpackage.jp;
import defpackage.q80;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Set;

/* loaded from: classes.dex */
public class RemoteControlManager {
    public static RemoteControlManager d;
    public BluetoothReceiver a = null;
    public Handler b = new a(this, Looper.getMainLooper());
    public BroadcastReceiver c = new b(this);

    /* loaded from: classes.dex */
    public class BluetoothReceiver extends BroadcastReceiver {
        public BluetoothReceiver() {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                aa0.a("RemoteControlManager", "[RemoteControlManager] BluetoothReceiver intent=null", new Object[0]);
                return;
            }
            Bundle extras = intent.getExtras();
            String action = intent.getAction();
            int i = 2;
            aa0.a("RemoteControlManager", "[RemoteControlManager] BluetoothReceiver intent={?}, action={?}", intent.toString(), action);
            if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                BluetoothDevice bluetoothDevice = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                aa0.a("RemoteControlManager", "[RemoteControlManager] BluetoothReceiver" + (bluetoothDevice != null ? bluetoothDevice.getName() : "") + " ACTION_ACL_CONNECTED", new Object[0]);
            } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                BluetoothDevice bluetoothDevice2 = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                aa0.a("RemoteControlManager", "[RemoteControlManager] BluetoothReceiver" + (bluetoothDevice2 != null ? bluetoothDevice2.getName() : "") + " ACTION_ACL_DISCONNECTED", new Object[0]);
                i = 0;
            } else if (extras != null) {
                i = extras.getInt("android.bluetooth.adapter.extra.STATE");
                if (RemoteControlManager.this.b != null && RemoteControlManager.this.b.hasMessages(1002) && i == 12) {
                    RemoteControlManager.this.b.removeMessages(1002);
                    aa0.a("RemoteControlManager", "[RemoteControlManager] BluetoothReceiver removeMessages WHAT_BT_CHECK_TIMEOUT", new Object[0]);
                }
            } else {
                i = -1;
            }
            aa0.a("RemoteControlManager", "[RemoteControlManager] BluetoothReceiver onReceive:{?}", Integer.valueOf(i));
            AndroidRemoteControl.notifySystemBluetoothChange(i);
        }
    }

    /* loaded from: classes.dex */
    public class a extends Handler {
        public a(RemoteControlManager remoteControlManager, Looper looper) {
            super(looper);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            aa0.a("RemoteControlManager", "[RemoteControlManager][mHandler]enter handleMessage", new Object[0]);
            super.handleMessage(message);
            aa0.a("RemoteControlManager", "[RemoteControlManager] handleMessage what:{?}", Integer.valueOf(message.what));
            int i = message.what;
            if (i == 1000 || i == 1002) {
                AndroidRemoteControl.notifySystemBluetoothChange(10);
            }
        }
    }

    /* loaded from: classes.dex */
    public class b extends BroadcastReceiver {
        public b(RemoteControlManager remoteControlManager) {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            aa0.a("RemoteControlManager", "[RemoteControlManager] myNetReceiver action == {?}", action);
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                AndroidRemoteControl.notifySystemWifiChange(1);
            }
        }
    }

    /* loaded from: classes.dex */
    public static class c implements Runnable {
        public WeakReference<BluetoothAdapter> a;

        public c(BluetoothAdapter bluetoothAdapter) {
            this.a = new WeakReference<>(bluetoothAdapter);
        }

        @Override // java.lang.Runnable
        public void run() {
            boolean z;
            BluetoothAdapter bluetoothAdapter = this.a.get();
            if (bluetoothAdapter != null) {
                try {
                    if (jp.I().l(10023)) {
                        z = jp.I().l(10025);
                    } else {
                        z = bluetoothAdapter.enable();
                    }
                } catch (Exception e) {
                    aa0.a("Exception", e, new Object[0]);
                    z = false;
                }
                aa0.a("RemoteControlManager", "[RemoteControlMainFragment] openBluetooth mAdapter.enable():{?}", Boolean.valueOf(z));
                if (z) {
                    return;
                }
                aa0.a("RemoteControlManager", "[RemoteControlMainFragment] openBluetooth mAdapter enabled false", new Object[0]);
                AndroidRemoteControl.notifySystemBluetoothChange(10);
            }
        }
    }

    public RemoteControlManager() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] RemoteControlManager", new Object[0]);
    }

    public static synchronized RemoteControlManager u() {
        RemoteControlManager remoteControlManager;
        synchronized (RemoteControlManager.class) {
            if (d == null) {
                d = new RemoteControlManager();
            }
            remoteControlManager = d;
        }
        return remoteControlManager;
    }

    public static int v() {
        aa0.a("RemoteControlManager", "[getWifiDirectState]", new Object[0]);
        q80.v();
        return q80.w();
    }

    public static boolean w() {
        aa0.a("RemoteControlManager", "[isLinkNetDevice]", new Object[0]);
        q80.v();
        return q80.x();
    }

    public boolean b(String str) {
        aa0.a("RemoteControlManager", "[RemoteControlManager] isContainedInBTParied", new Object[0]);
        String[] e = e();
        if (e != null) {
            for (String str2 : e) {
                if (str2.equals(str)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void c() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] destroy", new Object[0]);
        q80.v().r();
        q80.u();
        if (d != null) {
            d = null;
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:10:0x00ce  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public java.lang.String d() {
        /*
            Method dump skipped, instructions count: 243
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.amapauto.remotecontrol.RemoteControlManager.d():java.lang.String");
    }

    public String[] e() {
        int i = 0;
        aa0.a("RemoteControlManager", "[RemoteControlManager] getPairedDeviceAddress", new Object[0]);
        BluetoothAdapter a2 = q80.v().a();
        if (a2 == null) {
            return null;
        }
        Set<BluetoothDevice> bondedDevices = a2.getBondedDevices();
        if (bondedDevices == null) {
            aa0.a("RemoteControlManager", "[RemoteControlManager] getPairedDeviceAddress devices == null", new Object[0]);
            return null;
        }
        String[] strArr = new String[bondedDevices.size()];
        Iterator<BluetoothDevice> it = bondedDevices.iterator();
        while (it.hasNext()) {
            strArr[i] = it.next().getAddress();
            i++;
        }
        return strArr;
    }

    public String f() {
        return q80.v().b();
    }

    public String g() {
        return q80.v().c();
    }

    public void h() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] RemoteControlManager init:{?}", this);
    }

    public void i() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] initBluetoothServer", new Object[0]);
        q80.v().d();
    }

    public void j() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] initWifiChangeReceive", new Object[0]);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            ee.A().e().registerReceiver(this.c, intentFilter);
        } catch (Exception e) {
            aa0.a("RemoteControlManager", "[initWifiChangeReceive]Exception", e, new Object[0]);
        }
    }

    public void k() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] initWifiServer", new Object[0]);
        q80.v().f();
    }

    public boolean l() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] isBluetoothAdapterEnabled", new Object[0]);
        BluetoothAdapter a2 = q80.v().a();
        if (a2 == null) {
            return false;
        }
        if (jp.I().l(10023)) {
            boolean l = jp.I().l(10024);
            aa0.a("RemoteControlManager", "[isBluetoothAdapterEnabled]adapter bluetooth isEnabled:{?}", Boolean.valueOf(l));
            return l;
        }
        boolean isEnabled = a2.isEnabled();
        aa0.a("RemoteControlManager", "[isBluetoothAdapterEnabled]isEnabled:{?}", Boolean.valueOf(isEnabled));
        return isEnabled;
    }

    public void m() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] openBluetooth", new Object[0]);
        BluetoothAdapter a2 = q80.v().a();
        if (a2 != null) {
            aa0.a("RemoteControlManager", "[RemoteControlManager][openBluetooth]had BluetoothAdapter", new Object[0]);
            new Thread(new c(a2)).start();
            this.b.sendEmptyMessageDelayed(1002, 5000L);
        } else {
            aa0.a("RemoteControlManager", "[RemoteControlManager][openBluetooth]don't had BluetoothAdapter", new Object[0]);
            this.b.sendEmptyMessage(1000);
        }
    }

    public void n() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] registerBluetoothReceiver", new Object[0]);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.a = new BluetoothReceiver();
        try {
            ee.A().e().registerReceiver(this.a, intentFilter);
        } catch (Exception e) {
            aa0.a("RemoteControlManager", "[registerBluetoothReceiver]Exception", e, new Object[0]);
        }
    }

    public void o() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] removeBluetoothConnectChangeListener", new Object[0]);
        q80.v().i();
    }

    public void p() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] removeWifiConnectChangeListener", new Object[0]);
        q80.v().j();
    }

    public void q() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] stopBluetoothLink", new Object[0]);
        q80.v().n();
    }

    public void r() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] stopWifiLink", new Object[0]);
        q80.v().s();
    }

    public void s() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] unRegisterBluetoothReceiver", new Object[0]);
        try {
            if (this.a != null) {
                ee.A().e().unregisterReceiver(this.a);
            }
        } catch (Exception e) {
            aa0.a("RemoteControlManager", "[unRegisterBluetoothReceiver]unregisterReceiver", e, new Object[0]);
        }
    }

    public void t() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] uninitWifiChangeReceive", new Object[0]);
        try {
            if (this.c != null) {
                ee.A().e().unregisterReceiver(this.c);
            }
        } catch (Exception e) {
            aa0.a("RemoteControlManager", "[uninitWifiChangeReceive]unregisterReceiver", e, new Object[0]);
        }
    }

    public void a() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] addBluetoothConnectChangeListener", new Object[0]);
        q80.v().l();
    }

    public void a(int i, String str, String str2, boolean z) {
        aa0.a("RemoteControlManager", "operate = {?},arg1 = {?},arg2 = {?},arg3 = {?}", Integer.valueOf(i), str, str2, Boolean.valueOf(z));
        q80.v().a(i, str, str2, z);
    }

    public void b() {
        aa0.a("RemoteControlManager", "[RemoteControlManager] addWifiConnectChangeListener", new Object[0]);
        q80.v().m();
    }

    public static void c(int i) {
        aa0.a("RemoteControlManager", "[netProxyState] state = {?}", Integer.valueOf(i));
        q80.v();
        q80.d(i);
    }

    public void a(String str) {
        aa0.a("RemoteControlManager", "[RemoteControlManager] activeConnectBluetooth", new Object[0]);
        q80.v().a(str);
    }

    public static long b(int i) {
        aa0.a("RemoteControlManager", "[getTrafficCount] type = {?}", Integer.valueOf(i));
        q80.v();
        return q80.c(i);
    }

    public void a(int i) {
        aa0.a("RemoteControlManager", "[RemoteControlManager] initHttpServer", new Object[0]);
        q80.v().a(i);
    }
}
